<div>
    <?php if(session('success')): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <?php echo e(session('success')); ?>

        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
    <?php endif; ?>
    <?php if($inboxes->count() > 0): ?>
    <div class="d-lg-flex mb-3">
        <div>
            <label for="">search</label>
            <input type="text" class="form-control" placeholder="Search" wire:model='search'>
        </div>
        &nbsp; &nbsp;
        <div class="d-flex">
            <div>
                <label for="">status</label>
                <select class="form-control" wire:model='status'>
                    <option value=""></option>
                    <option>open</option>
                    <option>closed</option>
                </select>
            </div>
            &nbsp; &nbsp;
            <div>
                <label for="">page</label>
                <select class="form-control" wire:model='per_page'>
                    <option>10</option>
                    <option>20</option>
                </select>
            </div>
            &nbsp; &nbsp;
            <div>
                <label for="">order</label>
                <select class="form-control" wire:model='order'>
                    <option value="desc">Descending</option>
                    <option value="asc">Ascending</option>
                </select>
            </div>
            &nbsp; &nbsp;
        </div>
        <div class="d-none d-lg-flex">
            <div>
                <label for="">from</label>
                <input type="date" wire:model="from_date" class="form-control">
            </div>
            &nbsp; &nbsp;
            <div>
                <label for="">to</label>
                <input type="date" wire:model="to_date" class="form-control">
            </div>
            <?php if($from_date != '' && $to_date != ''): ?>
            <div class="d-none d-lg-flex">
                <div>
                    <button class="btn btn-sm btn-primary" wire:click='resetFilters'>reset date</button>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>
    <hr>
    <div class="table-responsive">
        <table class="table table-hover ">
            <thead>
                <tr>
                    <th>User</th>
                    <th>Subject</th>
                    <th>Message</th>
                    <th>Date Created</th>
                    <th>Reference</th>
                    <th>Status</th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $inboxes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $inbox): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr x-data=manage_inboxes>
                    <td><?php echo e($inbox->user->name); ?></td>
                    <td><?php echo e($inbox->subject); ?></td>
                    <td> <?php echo e($shorten($inbox->latest_conversation->content)); ?> </td>
                    <td> <?php echo e($inbox->date->format('d-m-Y h:i:s a')); ?> </td>
                    <td> <?php echo e($inbox->ref); ?> </td>
                    <td>
                        <span class="<?php echo \Illuminate\Support\Arr::toCssClasses([ 'badge' , 'bg-success'=> $inbox->status == 'open',
                            'bg-danger' => $inbox->status == 'closed',
                            ]) ?>"> <?php echo e($inbox->status); ?>

                        </span>
                    </td>
                    <td>
                        <div class="dropdown">
                            <i class="fa fa-ellipsis-v dropdown-toggle" type="button" data-toggle="dropdown"
                                aria-expanded="false"></i>
                            <div class="dropdown-menu">
                                <a class="dropdown-item" href="<?php echo e(route('admin.inbox.details', $inbox->ref)); ?>">
                                    <i class="fa fa-eye"></i> View Details
                                </a>
                                <a class="dropdown-item" href="<?php echo e(route('admin.inbox.conversations', $inbox->ref)); ?>">
                                    <i class="fa fa-comments"></i> View Conversations
                                </a>
                                <a class="dropdown-item" href="#" @click="delete_inbox(<?php echo \Illuminate\Support\Js::from($inbox->id)->toHtml() ?>)">
                                    <i class="fa fa-trash"></i> Delete
                                </a>
                            </div>
                        </div>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
        <?php echo e($inboxes->links()); ?>

    </div>
    <div class="d-flex d-lg-none">
        <div>
            <label for="">from</label>
            <input type="date" wire:model="from_date" class="form-control">
        </div>
        &nbsp; &nbsp;
        <div>
            <label for="">to</label>
            <input type="date" wire:model="to_date" class="form-control">
        </div>
        <?php if($from_date != '' && $to_date != ''): ?>
        <div class="d-block d-lg-none">
            <div>
                <button class="btn btn-sm btn-primary" wire:click='resetFilters'>reset
                    date</button>
            </div>
        </div>
        <?php endif; ?>
    </div>
    <?php else: ?>
    <div class="text-center py-5">
        <img src="<?php echo e(asset('dash/images/cloud-database-svgrepo-com.svg')); ?>" alt="no record found" class="img-fluid">

        <?php if($search != '' || $status != 'All' || ($from_date != '' && $to_date != '')): ?>
        <h1 class="mt-3 font-weight-bolder text-info">No Result found</h1>
        <p>We couldn't find what you are looking for. Try again.</p>
        <button type="button" class="btn btn-primary" wire:click='resetFilters'>
            Try again
        </button>
        <?php else: ?>
        <h1 class="mt-3 font-weight-bolder text-info">No Data found</h1>
        <p>
            You do not have any inboxes yet. <br> When your users place a
            withdrawal request, it will appear here.
        </p>
        <?php endif; ?>
    </div>
    <?php endif; ?>

    <script>
        document.addEventListener('alpine:init', () => {
            Alpine.data('manage_inboxes', () => ({
                delete_inbox(id) {
                    if (confirm(
                        'Are you sure you want to delete this inbox and its conversations?')) {
                        this.$wire.deleteInbox(id)
                    }
                }
            }))
        })
    </script>
</div><?php /**PATH /home/infosfg/worldquantumleap.org/resources/views/livewire/admin/inbox/manage.blade.php ENDPATH**/ ?>