@extends('layouts.dash')
@section('title', $title)
@section('content')
    <div class="content-wrapper">

        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-left mb-0">Withdrawal Accounts</h2>
                        <div class="breadcrumb-wrapper col-12">
                            <ol class="breadcrumb">

                                <li class="breadcrumb-item">
                                    <a href="/dashboard"> Home </a>
                                </li>
                                <li class="breadcrumb-item">
                                    <a href="/dashboard/withdrawal_accounts"> Withdrawal Accounts
                                    </a>
                                </li>
                                <li class="breadcrumb-item">
                                    Withdrawal Accounts </li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">

            <div class="row">
                <div class="col-12">

                </div>
            </div>
            <!-- // Basic multiple Column Form section start -->
            <section id="multiple-column-form">
                <div class="row match-height">
                    <div class="col-lg-8">
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title"></h4>
                            </div>
                            <div class="card-content">
                                <div class="card-body">
                                    <form action="{{ route('add-withdrawal-account') }}" class="form" method="post">
                                        @csrf
                                        <div class="form-body">
                                            <div class="row">
                                                <div class="col-md-12 col-12">
                                                    <div class="form-label-group">

                                                        <x-form.select id="email-id-column" name="account" class="form-control form-control-lg">
                                                            <option value="">Select an Account</option>
                                                            @foreach ($user->balances as $balance)
                                                                <option value="{{ $balance->wdmethod_id }}">{{ $balance->wdmethod->symbol }}</option>
                                                            @endforeach
                                                        </x-form.select>
                                                        <label for="email-id-column">Account</label>
                                                    </div>
                                                </div>
                                                <div class="col-md-6 col-12">
                                                    <div class="form-label-group">
                                                            <x-form.input name="address" id="first-name-column"
                                                            class="form-control form-control-lg" placeholder="Wallet Address" value="{{ old('address') }}" />

                                                        <label for="first-name-column">Wallet<label>
                                                    </div>
                                                </div>
                                                
                                                <div class="col-md-6 col-12">
                                                    <div class="form-label-group">
                                                            <x-form.input name="amount" class="form-control form-control-lg" placeholder="Amount" value="{{ old('amount') }}"  />

                                                        <label>Amount<label>
                                                    </div>
                                                </div>

                                                <div class="col-12 text-center">
                                                    <button type="submit" class="btn btn-primary mr-1 mb-1">Submit</button>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4 col-sm-12">
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title"> </h4>
                            </div>
                            <div class="card-content collapse show">
                                <div class="card-body">
                                    <p class="text-left text-danger" style="font-size:15px;">
                                        Your account has been activated for Auto Withdrawal. Thus, no action is required to
                                        withdraw your funds, simply add your withdrawal accounts and your funds will be
                                        transferred to your wallet address automatically at the end of your investments
                                        cycle.
                                    </p>
                                    <p class="text-center">
                                        <b>{{ $settings->site_name }} Team</b>
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!-- // Basic Floating Label Form section end -->
            <!-- Zero configuration table -->
            <section id="basic-datatable">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title"></h4>
                            </div>
                            <div class="card-content">
                                <div class="card-body card-dashboard">
                                    <p class="card-text">

                                    </p>
                                    <div class="table-responsive">
                                        <table class="table zero-configuration">
                                            <thead>
                                                <tr>
                                                    <th>S/N</th>
                                                    <th>Amount</th>
                                                    <th>Status</th>
                                                    <th>Withdrawal Method</th>
                                                    <th>Wallet Address</th>
                                                    <th>Action</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($withdrawals as $withdrawal)
                                                <tr>
                                                    <td>{{ $id++ }}</td>
                                                    <td>{{ $withdrawal->amount }} {{ $withdrawal->payment_mode }}</td>
                                                    <td>{{ $withdrawal->status }}</td>
                                                    <td>{{ $withdrawal->payment_mode }}</td>
                                                    <td>{{ $withdrawal->paydetails }}</td>
                                                    <td>
                                                        <a href="{{ route('delete-withdrawal-account', $withdrawal->id) }}"
                                                            class="badge badge-danger"><i class="fa fa-time-circle"></i>
                                                            Delete</a>
                                                    </td>
                                                </tr>
                                                @endforeach
                                            </tbody>
                                            <tfoot>
                                                <tr>
                                                    <th>S/N</th>
                                                    <th>Amount</th>
                                                    <th>Status</th>
                                                    <th>Withdrawal Method</th>
                                                    <th>Wallet Address</th>
                                                    <th>Action</th>
                                                </tr>
                                            </tfoot>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!--/ Zero configuration table -->
        </div>
    </div>
@endsection
