@extends('layouts.dash')
@section('title', $title)
@section('content')
    <div class="content-wrapper">

        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-left mb-0">Balance Swapping</h2>
                        <div class="breadcrumb-wrapper col-12">
                            <ol class="breadcrumb">

                                <li class="breadcrumb-item">
                                    <a href="/dashboard"> Home </a>
                                </li>
                                <li class="breadcrumb-item">
                                    <a href="{{ route('withdrawalsdeposits') }}"> Balance Swapping </a>
                                </li>
                                <li class="breadcrumb-item">
                                    Balance Swapping </li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <a href="/dashboard"><i class="fa fa-arrow-circle-left"></i> Return</a>
            <br><br>
            <div class="row">
                <div class="col-12">

                </div>
            </div>
            <!-- // Basic multiple Column Form section start -->
            <section id="multiple-column-form">
                <div class="row match-height">
                    <div class="col-lg-8 mx-auto">
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title"></h4>
                            </div>
                            <div class="card-content">
                                <div class="card-body">
                                    <form action="{{ route('swap') }}" class="form" method="post" accept-charset="utf-8">
                                        @csrf
                                        <div class="form-body">
                                            <div class="row">
                                                <div class="col-md-12 col-12">
                                                    <div class="form-label-group">
                                                        <x-form.select name="from"
                                                            class="form-control form-control-lg">
                                                            <option value="">Select a Balance to Swap</option>
                                                            @foreach ($user->balances as $balance)
                                                                <option value="{{ $balance->wdmethod->symbol }}">
                                                                    {{ $balance->wdmethod->symbol }}
                                                                    ({{ number_format($balance->value, 2) }})
                                                                </option>
                                                            @endforeach
                                                        </x-form.select>
                                                        <label for="email-id-column">Swap From</label>
                                                    </div>
                                                </div>
                                                <div class="col-md-12 col-12">
                                                    <div class="form-label-group">
                                                        <x-form.select name="to"
                                                            class="form-control form-control-lg">
                                                            <option value="">Select a Balance to Swap To</option>
                                                            @foreach ($user->balances as $balance)
                                                                <option value="{{ $balance->wdmethod->symbol }}">
                                                                    {{ $balance->wdmethod->symbol }}
                                                                    ({{ number_format($balance->value, 2) }})
                                                                </option>
                                                            @endforeach
                                                        </x-form.select>
                                                        <label for="email-id-column">Swap To</label>
                                                    </div>
                                                </div>
                                                <div class="col-md-12 col-12">
                                                    <div class="form-label-group">
                                                        <x-form.input name="amount" class="form-control form-control-lg"
                                                            placeholder="Amount in USD" value="{{ old('amount') }}" />
                                                        <label for="first-name-column">Amount<label>
                                                    </div>
                                                </div>

                                                <div class="col-12 text-center">
                                                    <button type="submit" class="btn btn-primary mr-1 mb-1">Swap</button>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
@endsection
