@inject('uc', 'App\Http\Controllers\User\UsersController')
@extends('layouts.dash')
@section('title', $title)
@section('content')
    <!-- END: Header-->
    <div class="content-wrapper">

        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-left mb-0">Referral Bonus</h2>
                        <div class="breadcrumb-wrapper col-12">
                            <ol class="breadcrumb">

                                <li class="breadcrumb-item">
                                    <a href="/dashboard"> Home </a>
                                </li>
                                <li class="breadcrumb-item">
                                    <a href="/dashboard/withdrawal_accounts"> Referral Bonus </a>
                                </li>
                                <li class="breadcrumb-item">
                                    Referral Bonus </li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">

            <div class="row">
                <div class="col-12">

                </div>
            </div>
            <!-- // Basic multiple Column Form section start -->
            <section id="multiple-column-form">
                <div class="row match-height">
                    <div class="col-lg-8 mx-auto">
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title"></h4>
                            </div>
                            <div class="card-content">
                                <div class="card-header d-flex align-items-start pb-0">
                                    <div class="text-center">
                                        <h2 class="text-bold-700 mb-0">{{ $settings->currency }} {{ number_format($user->ref_bonus, 2) }}</h2>
                                        <p>Referral Bonus</p>
                                    </div>
                                    <div class="avatar bg-rgba-success p-50 m-0">
                                        <div class="avatar-content">
                                            <i class="feather icon-credit-card text-success font-medium-5"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!-- // Basic Floating Label Form section end -->
            <!-- // Basic multiple Column Form section start -->
            <section id="multiple-column-form">
                <div class="row match-height">
                    <div class="col-lg-8 mx-auto">
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title"></h4>
                            </div>
                            <div class="card-content">
                                <div class="col-sm-12 col-12">
                                    <div class="text-bold-600 font-medium-2 mb-1">
                                        Referral ID
                                    </div>
                                    <fieldset class="form-group position-relative input-divider-right">
                                        <input type="text" class="form-control" id="iconLeft4" value="{{ $user->username }}" readonly>
                                        <div class="form-control-position">
                                            <i class="feather icon-file"></i>
                                        </div>
                                    </fieldset>
                                </div>
                                <div class="col-sm-12 col-12">
                                    <div class="text-bold-600 font-medium-2 mb-1">
                                        Referral Link
                                    </div>
                                    <fieldset class="form-group position-relative input-divider-right">
                                        <input type="text" class="form-control" id="iconLeft4"
                                            value="{{ $user->referral_link }}" readonly>
                                        <div class="form-control-position">
                                            <i class="feather icon-file"></i>
                                        </div>
                                    </fieldset>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!-- Zero configuration table -->
            <section id="basic-datatable">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title"></h4>
                            </div>
                            <div class="card-content">
                                <div class="card-body card-dashboard">
                                    <p class="card-text">

                                    </p>
                                    <div class="table-responsive">
                                        <table class="table zero-configuration">
                                            <thead>
                                                <tr>
                                                    <th>Client name</th>
                                                    <th>Ref. level</th>
                                                    <th>Client status</th>
                                                    <th>Date registered</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                {!! $uc->getdownlines($users, $user->id) !!}
                                            </tbody>
                                            <tfoot>
                                                <tr>
                                                    <th>Client name</th>
                                                    <th>Ref. level</th>
                                                    <th>Client status</th>
                                                    <th>Date registered</th>
                                                </tr>
                                            </tfoot>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!--/ Zero configuration table -->
        </div>
    </div>
@endsection
