<div class="tab-pane active" id="account" aria-labelledby="account-tab" role="tabpanel">
    <!-- users edit media object start -->
    <div class="media mb-2">
        <a class="mr-2 my-25" href="#">
            <img src='{{ $user->profile_photo_path ?? "https://ui-avatars.com/api/?background=fff1e3&color=000&name=$user->name" }}'
                alt="users avatar" class="users-avatar-shadow rounded" height="64" width="64">
        </a>
        <div class="media-body mt-50">
            <h4 class="media-heading">{{ $user->name }}</h4>
        </div>
    </div>
    <form action="{{ route('profile.update-personal-details') }}" method="post">
        @csrf
        <div class="row">
            <div class="col-md-6">
                <div class="form-group">
                    <div class="controls">
                        <label>Username</label>
                        <input type="text" class="form-control" placeholder="Username" value="{{ $user->username }}"
                            required readonly>
                    </div>
                </div>
            </div>
            
            <div class="col-md-6">
                <div class="form-group">
                    <div class="controls">
                        <label>E-mail</label>
                        <input type="email" class="form-control" value="{{ $user->email }}" name="email" readonly>
                    </div>
                </div>
            </div>

            <div class="col-md-6">
                <div class="form-group">
                    <div class="controls">
                        <label>Name</label>
                        <x-form.input name="name" class="form-control"
                            placeholder="Name" value="{{ $user->name }}" />
                    </div>
                </div>
            </div>

            <div class="col-md-6">
                <div class="form-group">
                    <div class="controls">
                        <label>Phone</label>
                        <x-form.input class="form-control"
                            value="{{ $user->phone }}" placeholder="Phone" name="phone" />
                        <span><code>Please append your country code without the plus(+) e.g
                                1906 instead of +1906.</code></span>
                    </div>
                </div>
            </div>
            
            <div class="col-md-6">
                <div class="form-group">
                    <div class="controls">
                        <label>Date of Birth</label>
                        <x-form.input name="dob" class="form-control"
                            type="date" value="{{ $user->dob }}" />
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label>Country</label>
                    <x-form.select name="country"
                        class="form-control">
                        <option selected>{{ $user->country }}</option>
                        @include('auth.countries')
                    </x-form.select>
                </div>
            </div>
        </div>
        <div class="col-12 d-flex flex-sm-row flex-column justify-content-end mt-1">
            <button type="submit" class="btn btn-primary glow mb-1 mb-sm-0 mr-0 mr-sm-1">Save
                Changes</button>
        </div>
</div>
</form>
</div>
