@extends('layouts.dash')
@section('title', $title)
@section('content')
    <!-- END: Header-->
    <div class="content-wrapper">

        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-left mb-0">User Profile</h2>
                        <div class="breadcrumb-wrapper col-12">
                            <ol class="breadcrumb">

                                <li class="breadcrumb-item">
                                    <a href="/dashboard"> Home </a>
                                </li>
                                <li class="breadcrumb-item">
                                    <a href="/dashboard/profile"> User Profile </a>
                                </li>
                                <li class="breadcrumb-item">
                                    User Profile </li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">

            <!-- page users view start -->
            <section class="page-users-view">
                <div class="row">
                    <!-- account start -->
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">
                                <div class="card-title">Account</div>
                                <div class="row">
                                    <div class="col-2 users-view-image">
                                        <img src='{{ $user->profile_photo_path ?? "https://ui-avatars.com/api/?background=fff1e3&rounded=true&color=000&name=$user->name" }}'
                                            class="w-100 rounded mb-2" alt="avatar">
                                        <!-- height="150" width="150" -->
                                    </div>
                                    <div class="col-sm-4 col-12">
                                        <table>
                                            <tr>
                                                <td class="font-weight-bold">Username</td>
                                                <td>{{ $user->username }}</td>
                                            </tr>
                                            <tr>
                                                <td class="font-weight-bold">Name</td>
                                                <td>{{ $user->name }}</td>
                                            </tr>
                                            <tr>
                                                <td class="font-weight-bold">Email</td>
                                                <td>{{ $user->email }}</td>
                                            </tr>
                                        </table>
                                    </div>
                                    <div class="col-md-6 col-12 ">
                                        <table class="ml-0 ml-sm-0 ml-lg-0">
                                            <tr>
                                                <td class="font-weight-bold">Status</td>
                                                <td>
                                                    <span class="badge badge-success" @class([
                                                        'badge',
                                                        'badge-success' => $user->status == 'active',
                                                        'badge-danger' => $user->status != 'active',
                                                    ])>
                                                        {{ ucfirst($user->status) }}
                                                    </span>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="font-weight-bold">Role</td>
                                                <td>Investor</td>
                                            </tr>
                                            @if ($user->kyc)
                                                <tr>
                                                    <td class="font-weight-bold">Occupation</td>
                                                    <td>{{ $user->kyc->occupation }}</td>
                                                </tr>
                                            @endif
                                        </table>
                                    </div>
                                    <div class="col-12">
                                        <a href="{{ route('edit-profile') }}" class="btn btn-primary mr-1">
                                            <i class="feather icon-edit-1"></i>
                                            Edit
                                        </a>
                                        <!-- Modal -->
                                        <button type="button" class="btn btn-outline-primary" data-toggle="modal"
                                            data-target="#kycForm">
                                            KYC
                                        </button>
                                        <!-- Modal -->
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- account end -->
                    <!-- information start -->
                    <div class="col-md-6 col-12 ">
                        <div class="card">
                            <div class="card-body">
                                <div class="card-title mb-2">Information</div>
                                <table>
                                    @if ($user->kyc)
                                        <tr>
                                            <td class="font-weight-bold">Birth Date </td>
                                            <td>{{ $user->kyc->dob->format('d F Y') }}</td>
                                        </tr>
                                    @endif
                                    <tr>
                                        <td class="font-weight-bold">Mobile</td>
                                        <td>{{ $user->phone }}</td>
                                    </tr>
                                    <tr>
                                        <td class="font-weight-bold">Email Status</td>
                                        <td>
                                            <span @class([
                                                'badge',
                                                'badge-success' => $user->hasVerifiedEmail(),
                                                'badge-danger' => !$user->hasVerifiedEmail(),
                                            ])>
                                                {{ $user->hasVerifiedEmail() ? 'Verified' : 'Not Verified' }}
                                            </span>
                                            @if (!$user->hasVerifiedEmail())
                                                <a href="{{ route('verification.notice') }}"><i>Verify</i></a>
                                            @endif
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="font-weight-bold">Country</td>
                                        <td>{{ $user->country }}</td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                    </div>
                    <!-- information start -->

                </div>
            </section>
            <!-- page users view end -->
        </div>
    </div>
    <!-- End: Content-->
    @include('includes.kyc-form')
    @if ($errors->any())
        <script>
            $(document).ready(function() {
                $('#kycForm').modal('show');
            });
        </script>
    @endif
@endsection
