@extends('layouts.dash')
@section('title', $title)
@section('content')
    <div class="content-wrapper">

        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-left mb-0">Notifications</h2>
                        <div class="breadcrumb-wrapper col-12">
                            <ol class="breadcrumb">

                                <li class="breadcrumb-item">
                                    <a href="/dashboard"> Home </a>
                                </li>
                                <li class="breadcrumb-item">
                                    <a href="/dashboard/deposits"> Notifications </a>
                                </li>
                                <li class="breadcrumb-item">
                                    Notifications </li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">

            <div class="row">
                <div class="col-12">
                    <p>Make a fresh Deposit <a href="/dashboard/deposit">here</a></p>
                </div>
            </div>
            <!-- Zero configuration table -->
            <section id="basic-datatable">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title"></h4>
                            </div>
                            <div class="card-content">
                                <div class="card-body card-dashboard">
                                    <p class="card-text">

                                    </p>
                                    <div class="table-responsive">
                                        <table class="table zero-configuration">
                                            <thead>
                                                <tr>
                                                    <th>S/N</th>
                                                    <th>Title</th>
                                                    <th>Activity</th>
                                                    <th>Action</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach ($user->Notifications as $notification)
                                                    <tr>
                                                        <td>{{ $id++ }}</td>
                                                        <td>{{ $notification->data['title'] }}</td>
                                                        <td>{{ $notification->data['message'] }}</td>
                                                        <td>
                                                            @if($notification->read_at)
                                                            <span class="badge badge-success">Read</span>
                                                            @else
                                                            <a href="{{ route('read-notification', $notification->id) }}"
                                                            class="badge badge-primary"><i class="fa fa-eye"></i></a>
                                                            @endif
                                                        </td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                            <tfoot>
                                                <tr>
                                                    <th>S/N</th>
                                                    <th>Title</th>
                                                    <th>Activity</th>
                                                    <th>Action</th>
                                                </tr>
                                            </tfoot>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!--/ Zero configuration table -->
        </div>
    </div>
@endsection
