@extends('layouts.dash')
@section('title', $title)
@section('content')
    <div class="content-wrapper">

        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-left mb-0">New Investment</h2>
                        <div class="breadcrumb-wrapper col-12">
                            <ol class="breadcrumb">

                                <li class="breadcrumb-item">
                                    <a href="/dashboard/dashboard"> Home </a>
                                </li>
                                <li class="breadcrumb-item">
                                    <a href="/dashboard/deposit"> New Investment </a>
                                </li>
                                <li class="breadcrumb-item">
                                    New Investment </li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <a href="/dashboard/invest"><i class="fa fa-arrow-circle-left"></i> Return</a>
            <br><br>

            <section id="multiple-column-form">
                <div class="row match-height">
                    <div class="col-lg-8 mx-auto">
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title">{{ $plan->name }}</h4>
                            </div>
                            <div class="card-content">
                                <div class="card-body">
                                    <form class="form" method="post">
                                        @csrf
                                        <div class="form-body">
                                            <div class="row">
                                                <div class="col-md-12 col-12">
                                                    <div class="form-label-group">
                                                        <input id="first-name-column"
                                                            class="form-control form-control-lg" placeholder="Amount"
                                                            value="{{$plan->min_price ? number_format($plan->min_price, 2): 'Unlimited'}}" disabled>
                                                        <label for="first-name-column">Minimum Amount($</label>
                                                    </div>
                                                </div>
                                                <div class="col-md-12 col-12">
                                                    <div class="form-label-group">
                                                        <input id="second-name-column"
                                                            class="form-control form-control-lg"
                                                            value="{{ $plan->max_price ? number_format($plan->max_price, 2): 'Unlimited' }}" disabled>
                                                        <label for="second-name-column">Maximum Amount  ($)</label>
                                                    </div>
                                                </div>
                                                <div class="col-md-12 col-12">
                                                    <div class="form-label-group">
                                                        <x-form.input id="amount-column" name="amount" class="form-control form-control-lg"
                                                            placeholder="Amount in USD" value="{{ old('amount') }}" />
                                                        <label for="amount-column">Amount ($)</label>
                                                    </div>
                                                </div>

                                                <div class="col-md-12 col-12">
                                                    <div class="form-label-group">
                                                        <x-form.select id="email-id-column" name="balance" class="form-control form-control-lg">
                                                            <option value="">Select Balance To Debit </option>
                                                            @foreach ($user->balances as $balance)
                                                                <option value="{{ $balance->wdmethod->symbol }}">
                                                                    {{ $balance->wdmethod->symbol }}
                                                                    ({{ number_format($balance->value, 2) }})
                                                                </option>
                                                            @endforeach
                                                        </x-form.select>
                                                        <label for="email-id-column">Debit</label>
                                                    </div>
                                                </div>

                                                <div class="col-12 text-center">
                                                    <button type="submit" class="btn btn-primary mr-1 mb-1">Submit</button>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>

        </div>
    </div>
@endsection
