@extends('layouts.dash')
@section('title', $title)
@section('content')
    <<!-- END: Header-->
        <div class="content-wrapper">
            <div class="content-header row">
                <div class="content-header-left col-md-9 col-12 mb-2">
                    <div class="row breadcrumbs-top">
                        <div class="col-12">
                            <h2 class="content-header-title float-left mb-0">Investment History</h2>
                            <div class="breadcrumb-wrapper col-12">
                                <ol class="breadcrumb">

                                    <li class="breadcrumb-item">
                                        <a href="/dashboard"> Home </a>
                                    </li>
                                    <li class="breadcrumb-item">
                                        <a href="/dashboard/investments"> Investment History </a>
                                    </li>
                                    <li class="breadcrumb-item">
                                        Investment History </li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="content-body">
                <a href="/dashboard/investments"><i class="fa fa-arrow-circle-left"></i>
                    Return</a>
                <br><br>
                <div class="row">
                    <div class="col-12">
                        <p>Make a fresh Investment <a href="/dashboard/invest">here</a></p>
                    </div>
                </div>
                <!-- Zero configuration table -->
                <section id="basic-datatable">
                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title"></h4>
                                </div>
                                <div class="card-content">
                                    <div class="card-body card-dashboard">
                                        <p class="card-text">

                                        </p>
                                        <div class="table-responsive">
                                            <table class="table zero-configuration">
                                                <thead>
                                                    <tr>
                                                        <th>S/N</th>
                                                        <th>Plan</th>
                                                        <th>Amount($)</th>
                                                        <th>Investment Cycle</th>
                                                        <th>Status</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach ($investments as $investment)
                                                        <tr>
                                                            <td> {{ $id++ }} </td>
                                                            <td> {{ $investment->dplan->name }} </td>
                                                            <td> {{ number_format($investment->amount, 2) }} </td>
                                                            <td> {{ $investment->dplan->increment_amount }}% {{ $investment->dplan->increment_interval }}</td>
                                                            <td> <span @class([
                                                                'badge', 
                                                                'bg-success' => $investment->active=='yes',
                                                                'bg-danger' => $investment->active=='expired',
                                                                ])>{{ $investment->status }} </span></td>
                                                        </tr>
                                                    @endforeach
                                                </tbody>
                                                <tfoot>
                                                    <tr>
                                                        <th>S/N</th>
                                                        <th>Plans</th>
                                                        <th>Amount($)</th>
                                                        <th>Investment Cycle</th>
                                                        <th>Status</th>
                                                    </tr>
                                                </tfoot>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
                <!--/ Zero configuration table -->
            </div>
        </div>

    @endsection
