@extends('layouts.dash')
@section('title', $title)
@section('content')
    <style>
        .circle {
            background: #5D3FD3;
            border-radius: 50%;
            color: white;
            height: 150px;
            font-weight: bold;
            width: 150px;
            display: table;
            margin: 1px auto;
            box-shadow: 0 5px 10px rgba(0, 0, 0, .2);
        }

        .circle p {
            vertical-align: middle;
            display: table-cell;
            text-align: center;
        }

        #coll {
            vertical-align: middle;
            display: table-cell;
            text-align: center;
        }
    </style>
    <div class="content-wrapper">

        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-left mb-0">New Investment</h2>
                        <div class="breadcrumb-wrapper col-12">

                            <ol class="breadcrumb">

                                <li class="breadcrumb-item">
                                    <a href="/dashboard"> Home </a>
                                </li>
                                <li class="breadcrumb-item">
                                    <a href="/dashboard/deposit"> New Investment </a>
                                </li>
                                <li class="breadcrumb-item">
                                    New Investment </li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <section id="multiple-column-form">
                <a href="/dashboard"><i class="fa fa-arrow-circle-left"></i> Return</a>
                <br><br>
                <div class="row">

                    @foreach($plans as $plan)
                    <div class="col-lg-4 col-md-6 col-12">
                        <div class="card">
                            <div class="circle">
                                <p>
                                    {{ $plan->name }} <br>
                                    <a class="btn btn-warning btn-sm" data-action="collapse">
                                        <i class="fa fa-chevron-down"></i>
                                    </a>
                                </p>
                            </div>
                            <div class="card-content collapse">
                                <hr style="height:1px;border:none;color:#333;background-color:#333;">
                                <div class="card-body">
                                    <p class="card-text text-dark text-center" style="font-size:14px;">
                                        {!! $plan->description !!}<br><br>
                                        <a href="{{ route('start-investment', $plan->id) }}"
                                            class="btn btn-md btn-primary">Enroll</a>
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endforeach
                </div>
            </section>
        </div>
    </div>
@endsection
