@extends('layouts.dash')
@section('title', $title)
@section('content')
    <div class="content-wrapper">

        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-left mb-0">Conversation</h2>
                        <div class="breadcrumb-wrapper col-12">
                            <ol class="breadcrumb">

                                <li class="breadcrumb-item">
                                    <a href="/dashboard"> Home </a>
                                </li>
                                <li class="breadcrumb-item">
                                    <a href="/dashboard/inbox"> Conversation </a>
                                </li>
                                <li class="breadcrumb-item">
                                    Conversation </li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <a href="/dashboard"><i class="fa fa-arrow-circle-left"></i> Return</a>
            <br><br>
            <div class="row">
                <div class="col-12">

                </div>
            </div>
            <!-- Zero configuration table -->
            <section id="basic-datatable">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title"></h4>
                            </div>
                            <div class="card-content">
                                <div class="card-body card-dashboard">
                                    <p class="card-text">
                                        <!--SHOWING MESSAGE{SUCCESS OR FAILURE}-->
                                        <!--//SHOWING MESSAGE{SUCCESS OR FAILURE}-->

                                        <br><br>
                                        <button class="btn btn-primary text-center" data-toggle="modal"
                                            data-target="#supportRequestModal">Start New Support</button>
                                    </p>
                                    <div class="table-responsive">
                                        <table class="table zero-configuration">
                                            <thead>
                                                <tr>
                                                    <th>S/N</th>
                                                    <th>Reference</th>
                                                    <th>Subject</th>
                                                    <th>Message</th>
                                                    <th>Date</th>
                                                    <th>Status</th>
                                                </tr>
                                            </thead>
                                            <tbody>

                                                @foreach ($user->inboxes as $inbox)
                                                    <tr>
                                                        <td>{{ $id++ }}</td>
                                                        <td>
                                                            <a class="badge badge-primary"
                                                                href="{{ route('inbox-details', $inbox->ref) }}">{{ $inbox->ref }}</a>
                                                        </td>
                                                        <td>{{ $inbox->subject }}</td>
                                                        <td>{{ $shorten($inbox->latest_conversation->content) }}</td>
                                                        <td> {{ $inbox->date->format('d-m-Y h:i:s a') }} </td>
                                                        <td> <span @class([
                                                            'badge',
                                                            'bg-success' => $inbox->status == 'open',
                                                            'bg-danger' => $inbox->status == 'closed',
                                                        ])> {{ $inbox->status }}
                                                            </span> </td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                            <tfoot>
                                                <tr>
                                                    <th>S/N</th>
                                                    <th>Reference</th>
                                                    <th>Subject</th>
                                                    <th>Message</th>
                                                    <th>Date</th>
                                                    <th>Status</th>
                                                </tr>
                                            </tfoot>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>

    <form action="{{ route('inbox.create') }}" method="POST">
        <x-widgets.modal id="supportRequestModal" title="Support Request Form">
            @csrf
            <label>Subject: </label>
            <div class="form-group">
                <x-form.input name="subject" placeholder="Subject"
                    class="form-control" />
            </div>

            <label>Message: </label>
            <div class="form-group">
                <x-form.textarea name="message" class="form-control"
                    rows="4" />
            </div>

            <x-slot name="footer">
                <button type="submit" class="btn btn-primary text-center">Submit</button>
            </x-slot>
        </x-widgets.modal>
    </form>
    @if ($errors->any())
        <script>
            $(document).ready(function() {
                $('#supportRequestModal').modal('show');
            });
        </script>
    @endif


@endsection
