@extends('layouts.dash')
@section('title', $title)
@section('content')
    <div class="content-wrapper">

        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-left mb-0">Conversation Responses</h2>
                        <div class="breadcrumb-wrapper col-12">
                            <ol class="breadcrumb">

                                <li class="breadcrumb-item">
                                    <a href="/dashboard"> Home </a>
                                </li>
                                <li class="breadcrumb-item">
                                    <a href="/dashboard/inbox"> Conversation Responses </a>
                                </li>
                                <li class="breadcrumb-item">
                                    Conversation Responses </li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <a href="/dashboard/inbox"><i class="fa fa-arrow-circle-left"></i> Return</a>
            <br><br>

            @if($inbox->status == 'closed')
            <div class="alert alert-warning" role="alert">
                <h4 class="alert-heading">Closed</h4>
                <p class="mb-0">
                  This conversation has been ended. However, send a reply to reopen the conversation.
                </p>
            </div>
            @endif

            @if($inbox->status == 'open')
            <a href="{{ route('close-inbox', $inbox->ref) }}"
                class="btn btn-warning btn-block"> Close Conversation</a>
            <br>
            @endif
            <section id="overlay-image-chat-cards">
                <div class="row">
                    <div class="col-lg-9 col-md-12 col-12 mx-auto">
                        <div class="card chat-application">
                            <div class="card-header">
                                <h4 class="card-title">Reference: #{{ $inbox->ref }}</h4><br>
                                <p class="card-text">

                                </p>
                            </div>
                            <div class="chat-app-window">
                                <div class="user-chats">
                                    <div class="chats">
                                        @foreach ($conversations as $conversation)
                                            <div class="chat">
                                                <div class="chat-avatar">
                                                    <a class="avatar m-0" data-toggle="tooltip" href="#"
                                                        data-placement="right" title="" data-original-title="">
                                                        @if($conversation->sender=='user')
                                                        <img src='{{ $user->profile_photo_path ?? "https://ui-avatars.com/api/?background=fff1e3&rounded=true&color=000&name=$user->name" }}'
                                                            alt="avatar" height="40" width="40" />
                                                        @endif

                                                        @if($conversation->sender=='admin')
                                                        <img src="https://ui-avatars.com/api/?name={{ $conversation->sender }}&rounded=true&background=a0a0a0"
                                                            alt="avatar" height="40" width="40" />
                                                        @endif
                                                    </a>
                                                </div>
                                                <div class="chat-body">
                                                    <div class="{{ $conversation->sender=='Support' ? 'chat-content-support' : 'chat-content' }}">
                                                        <p>{{ $conversation->content }}</p>
                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach

                                    </div>
                                </div>
                                <br>
                                <form action="{{ route('new-conversation', $inbox->ref)}}">
                                    <div class="chat-footer">
                                        <div class="card-body d-flex justify-content-around pt-0">
                                            <x-form.input name="message" class="form-control mr-50" placeholder="Type your Message" />
                                            <button type="submit" class="btn btn-icon btn-primary"><i
                                                    class="feather icon-navigation"></i></button>

                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
@endsection
