@extends('layouts.dash')
@section('title', $title)
@section('content')
    <div class="content-wrapper">

        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-left mb-0">Deposit List</h2>
                        <div class="breadcrumb-wrapper col-12">
                            <ol class="breadcrumb">

                                <li class="breadcrumb-item">
                                    <a href="/dashboard/dashboard"> Home </a>
                                </li>
                                <li class="breadcrumb-item">
                                    <a href="/dashboard/deposits"> Deposit List </a>
                                </li>
                                <li class="breadcrumb-item">
                                    Deposit List </li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">

            <div class="row">
                <div class="col-12">
                    <p>Make a fresh Deposit <a href="/dashboard/deposit">here</a></p>
                </div>
            </div>
            <!-- Zero configuration table -->
            <section id="basic-datatable">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title"></h4>
                            </div>
                            <div class="card-content">
                                <div class="card-body card-dashboard">
                                    <p class="card-text">

                                    </p>
                                    <div class="table-responsive">
                                        <table class="table zero-configuration">
                                            <thead>
                                                <tr>
                                                    <th>S/N</th>
                                                    <th>Asset</th>
                                                    <th>Amount($)</th>
                                                    <th>Transaction Hash</th>
                                                    <th>Date Received</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach ($deposits as $deposit)
                                                    <tr>
                                                        <td>{{ $id++ }}</td>
                                                        <td>{{ $deposit->wdmethod->name }}</td>
                                                        <td>{{ number_format($deposit->amount, 2) }} ({{ number_format($deposit->crypto_amount, 3) }} {{ $deposit->wdmethod->symbol }}) </td>
                                                        <td>{{ $deposit->hash }}</td>
                                                        <td>{{ $deposit->date_received }}</td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                            <tfoot>
                                                <tr>
                                                    <th>S/N</th>
                                                    <th>Asset</th>
                                                    <th>Crypto Amount</th>
                                                    <th>Amount($)</th>
                                                    <th>Transaction Hash</th>
                                                    <th>Date Received</th>
                                                </tr>
                                            </tfoot>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!--/ Zero configuration table -->
        </div>
    </div>

    </div>
    <!-- End: Content-->
@endsection
