@extends('layouts.dash')
@section('content')
    <!-- App Header -->
    <div class="appHeader">
        <div class="left">
            <a href="/dashboard" class="headerButton goBack">
                <ion-icon name="chevron-back-outline"></ion-icon>
            </a>
        </div>
        <div class="pageTitle">
            Deposit
        </div>
        <div class="right">
            <a href="#" class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#BuyCoin">Buy coin</a>
        </div>
    </div>
    <!-- * App Header --> <!-- App Capsule -->
    <div id="appCapsule" class="full-height">
        <ul class="listview flush transparent no-line image-listview detailed-list">
            <!-- item -->
            <li>
                <div class="item">
                    <div class="in">
                        <div>
                            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Mode
                        </div>
                        <div class="text-end">
                            <div class="chip chip-media">
                                <i class="chip-icon bg-primary text-white">
                                    <em class="icon ni ni-sign-{{ $coin->symbol }}-new-alt"></em>
                                </i>
                                <span class="chip-label text-black"><strong>{{ $coin->symbol }}</strong></span>
                            </div>
                        </div>
                    </div>
                </div>
            </li>
            <!-- * item -->
        </ul>
        <div class="section mt-2">
            <div style="border-top: 0.5px solid #ccc; border-bottom: 0.5px solid #ccc;">
                <div class="credit-card" style="width: 100%;">
                    <div class="circle1"></div>
                    <div class="circle2"></div>
                    <div class="head">
                        <div>
                            <img src="https://worldquantumleap.com/home/en/logo.png" width="100px">
                        </div>
                        <div>QFS Card</div>
                    </div>
                    <div class="number" style="ALIGN-CONTENT: center;">
                        <div>XXXX-</div>
                        <div>XXXX-</div>
                        <div>XXXX-</div>
                        <div>XXXX</div>
                    </div>
                    <div class="tail">
                        <div>{{ $user->name }}</div>
                        <div class="exp">Exp:
                            <span class="exp-date">12/{{ now()->addYear()->format('y') }}</span>
                        </div>
                    </div>
                </div>
            </div>
            <style>
                .credit-card {
                    background-color: #18181b;
                    color: #a1a1aa;
                    padding: 30px 30px;
                    border-radius: 0.5rem;
                    box-shadow: 0 20px 25px -5px rgb(0 0 0 / 0.1), 0 8px 10px -6px rgb(0 0 0 / 0.1);
                    width: 450px;
                    height: 250px;
                    display: flex;
                    flex-direction: column;
                    position: relative;
                    overflow: hidden;
                    transition: all 0.5s ease-in-out;
                }

                .credit-card:hover {
                    scale: 1.1;
                }

                .head,
                .number,
                .tail {
                    display: flex;
                    justify-content: space-between;
                    align-items: center;
                    font-weight: 600;
                    z-index: 10;
                }

                .head {
                    font-size: 1.3rem;
                    font-weight: bold;
                }

                .number {
                    margin-top: auto;
                    font-size: 1.5rem;
                    margin-bottom: 0.3rem;
                    color: #d4d4d8;
                }

                .exp {
                    font-size: 0.8rem;
                }

                .exp-date {
                    color: #d4d4d8;
                    font-size: 1.3rem;
                }

                .circle1 {
                    position: absolute;
                    width: 250px;
                    height: 250px;
                    background-color: #991b1b;
                    border-radius: 100%;
                    transform: translateY(-60%) translateX(100%);
                }

                .circle2 {
                    position: absolute;
                    width: 100px;
                    height: 100px;
                    background-color: #854d0e;
                    border-radius: 100%;
                    transform: translateY(190%);
                }
            </style>
            <p style="color:red">
                <img src="https://img.icons8.com/?size=96&id=5tH5sHqq0t2q&format=png" width="50">
                Fund your Card via a crypto transfer to start using the full suite of services. you need a minimum of
                $10,000
            </p> <label class="label" for="amount3">
                <h4 class="m-0">Deposit Address</h4>
            </label> <!-- You just need to get this field. -->
            <script src="https://kit.fontawesome.com/d97b87339f.js" crossorigin="anonymous"></script>
            <div class="clipboard">
                <input onclick="copy()" class="copy-input" value="{{ $coin->wallet_address }}" id="copyClipboard" readonly>
                <button class="copy-btn" id="copyButton" onclick="copy()"><i class="fa fa-copy"></i></button>
            </div>
            <div id="copied-success" class="copied">
                <span>Copied!</span>
            </div>
            <br>
            @if ($errors->any())
                <div class="alert alert-danger">
                    <ul class="m-0">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif
                <x-success-alert/>
            <form method="POST" enctype="multipart/form-data" id="form">
                @csrf
                <div class="form-group basic">
                    <div class="input-wrapper">
                        <label class="label" for="amount3">
                            <h4 class="m-0">{{ $coin->symbol }} amount</h4>
                        </label>
                        <input style="color:green" type="text" class="form-control" id="coin" onkeyup="coinvalue()"
                            name="amount" placeholder="$1000">
                        <i class="clear-input">
                            <ion-icon name="close-circle"></ion-icon>
                        </i>
                    </div><br>
                    <h3 style="color:#0070BA">Shipping Details</h3>
                    <div class="input-wrapper">
                        <input style="width: 100%;" type="text" value="{{ $user->name }}" name="name" required>
                    </div> <br>
                    <div class="input-wrapper"> <input style="width: 100%;" value="{{ $user->email }}" type="text"
                            name="email" required> </div> <br>
                    <div class="input-wrapper"> <input style="width: 100%;" Placeholder="Phone Number" type="text"
                            name="phone" required> </div> <br>
                    <div class="input-wrapper"> <input style="width: 100%;" Placeholder="Full Address" type="text"
                            name="address" required> </div> <br>
                    <label style="color:red"class="label" for="amount3">Attach screenshot of transaction</h4></label>
                    <input name="payment_receipt" type="file" required><br><br> <input type="radio" id="terms"
                        name="terms" value="Yes" required>
                    <label for="html">I accept QFS Shipping terms and conditions</label></label><br>
                </div>
                <div class="section mt-2">
                    <div class="form-button-group2  transparent2">
                        <button type="submit" class="btn btn-primary">Pre-Order</button>
                    </div>
                </div>
            </form>
        </div>
        <div class="modal fade" id="BuyCoin" tabindex="-1" role="dialog">
            <div class="modal-dialog modal-sm" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">Buy Coin</h4>
                        <a href="#" data-bs-dismiss="modal">Close</a>
                    </div>
                    <div class="modal-body">
                        <div style="background-color: #FFF8EB; margin:8px -15px 0 -15px !important; padding: 12px;">
                            <h3 class="text-primary h3" align="center">How to buy coin</h3>
                            <ol>
                                <li>Choose a Broker or Crypto Exchange.</li>
                                <li>To buy cryptocurrency, first you need to pick a broker or a crypto exchange.</li>
                                <li>Create and Verify Your Account.</li>
                                <li>Deposit Cash into your exchange account.</li>
                                <li>Select Send/Withdraw/Pay depending on your preferred exchanger.</li>
                                <li>Copy the wallet address of the coin you want to deposit from the deposit section</li>
                                <li>Proceed and make a payment into the wallet address of the coin you want to deposit.</li>
                            </ol>
                            <br>
                        </div>
                        <div class="listview-title mt-2">Tusted Exchanges</div>
                        <ul class="listview image-listview inset">
                            <li>
                                <a href="https://www.coinbase.com/" target="_blank" class="item">
                                    <img src="assets/img/coinbase.jpg" alt="image" class="image">
                                    <div class="in">
                                        <div>Coinbase</div>
                                    </div>
                                </a>
                            </li>
                            <li>
                                <a href="https://www.luno.com/" target="_blank" class="item">
                                    <img src="assets/img/luno-logo.png" alt="image" class="image">
                                    <div class="in">
                                        <div>Luno</div>
                                    </div>
                                </a>
                            </li>
                            <li>
                                <a href="https://paybis.com/" target="_blank" class="item">
                                    <img src="assets/img/pabis.webp" alt="image" class="image">
                                    <div class="in">
                                        <div>Paybis</div>
                                    </div>
                                </a>
                            </li>
                            <li>
                                <a href="https://www.binance.com/" target="_blank" class="item">
                                    <img src="assets/img/bnb-cryptocurrencies-icon.png" alt="image" class="image">
                                    <div class="in">
                                        <div>Binance</div>
                                    </div>
                                </a>
                            </li>
                            <li>
                                <a href="https://www.coinmama.com/" target="_blank" class="item">
                                    <img src="assets/img/coinmama.png" alt="image" class="image">
                                    <div class="in">
                                        <div>Coin Mama</div>
                                    </div>
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
        <!-- * Modal Basic --> <br /><br /><br />
        <hr />
        <div class="section mb-2">
            <div class="section-title text-black">Notes:</div>
            <style scoped="true">
                body,
                html {
                    height: 100%;
                    margin: 0;
                    padding: 0;
                    border: 0;
                }

                @keyframes _show {
                    0% {
                        opacity: 0
                    }

                    100% {
                        opacity: 1
                    }
                }

                img {
                    max-width: 100%
                }

                address {
                    font-style: italic
                }

                big {
                    display: inline;
                    font-size: 1.2em
                }

                blockquote {
                    background-color: #f6f6f6;
                    border-left: 3px solid #dbdbdb;
                    color: #6c6c6c;
                    padding: 5px 0 5px 10px
                }

                caption {
                    display: table-caption;
                    text-align: center
                }

                center {
                    text-align: center
                }

                cite {
                    font-style: italic
                }

                dd {
                    margin-left: 40px
                }

                mark {
                    background-color: yellow
                }

                pre {
                    font-family: monospace;
                    white-space: pre;
                    overflow: scroll
                }

                s {
                    text-decoration: line-through
                }

                small {
                    display: inline;
                    font-size: 0.8em
                }

                u {
                    text-decoration: underline
                }
            </style>
            <p>1. Send only {{ $coin->symbol }} to this wallet address. Sending any other Coins May result in permanent
                asset loss. </p>
            <p>2. Minimum deposit 10,000 USD Worth of {{ $coin->symbol }}. </p>
            <p>3. Ensure the Security of your Device browser. Do not expose your account login details. </p>
            <p>4. Deposit Requires 2~15 network confirmations to Arrive in your worldquantumleap Account.</p>
        </div>
    </div>
@endsection
