@extends('layouts.dash')
@section('title', $title)
@section('content')
    <div class="content-wrapper">
        <div class="content-body">
            <section id="dashboard-analytics">
                <div class="row">
                    
                    @foreach($user->balances as $balance)
                    <div class="col-lg-4 col-md-6 col-12">
                        <div class="card">
                            <div class="card-header d-flex flex-column align-items-start pb-0">
                                <div class="avatar bg-rgba-warning p-50 m-0">
                                    <div class="avatar-content">
                                        <i class="feather icon-package text-warning font-medium-5"></i>
                                    </div>
                                </div>
                                <h2 class="text-bold-700 mt-1 mb-25">
                                    {{ $settings->currency }} {{ number_format($balance->fiat_value, 3) }}<br>
                                    ({{ number_format($balance->value, 3) }} <span class="text-success">{{ $balance->wdmethod->symbol }}</span>)
                                </h2>
                                <p class="mb-0">
                                    {{ $balance->wdmethod->symbol }} Balance (Price: {{ number_format($balance->wdmethod->details->PRICE, 3) }})
                                </p>
                            </div>
                        </div>
                    </div>
                    @endforeach

                </div>
            </section>
        </div>
    </div>
@endsection
