<div>
    @if (session('success'))
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        {{ session('success') }}
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
    @endif
    @if ($inboxes->count() > 0)
    <div class="d-lg-flex mb-3">
        <div>
            <label for="">search</label>
            <input type="text" class="form-control" placeholder="Search" wire:model='search'>
        </div>
        &nbsp; &nbsp;
        <div class="d-flex">
            <div>
                <label for="">status</label>
                <select class="form-control" wire:model='status'>
                    <option value=""></option>
                    <option>open</option>
                    <option>closed</option>
                </select>
            </div>
            &nbsp; &nbsp;
            <div>
                <label for="">page</label>
                <select class="form-control" wire:model='per_page'>
                    <option>10</option>
                    <option>20</option>
                </select>
            </div>
            &nbsp; &nbsp;
            <div>
                <label for="">order</label>
                <select class="form-control" wire:model='order'>
                    <option value="desc">Descending</option>
                    <option value="asc">Ascending</option>
                </select>
            </div>
            &nbsp; &nbsp;
        </div>
        <div class="d-none d-lg-flex">
            <div>
                <label for="">from</label>
                <input type="date" wire:model="from_date" class="form-control">
            </div>
            &nbsp; &nbsp;
            <div>
                <label for="">to</label>
                <input type="date" wire:model="to_date" class="form-control">
            </div>
            @if ($from_date != '' && $to_date != '')
            <div class="d-none d-lg-flex">
                <div>
                    <button class="btn btn-sm btn-primary" wire:click='resetFilters'>reset date</button>
                </div>
            </div>
            @endif
        </div>
    </div>
    <hr>
    <div class="table-responsive">
        <table class="table table-hover ">
            <thead>
                <tr>
                    <th>User</th>
                    <th>Subject</th>
                    <th>Message</th>
                    <th>Date Created</th>
                    <th>Reference</th>
                    <th>Status</th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
                @foreach ($inboxes as $inbox)
                <tr x-data=manage_inboxes>
                    <td>{{ $inbox->user->name }}</td>
                    <td>{{ $inbox->subject }}</td>
                    <td> {{ $shorten($inbox->latest_conversation->content) }} </td>
                    <td> {{ $inbox->date->format('d-m-Y h:i:s a') }} </td>
                    <td> {{ $inbox->ref }} </td>
                    <td>
                        <span @class([ 'badge' , 'bg-success'=> $inbox->status == 'open',
                            'bg-danger' => $inbox->status == 'closed',
                            ])> {{ $inbox->status }}
                        </span>
                    </td>
                    <td>
                        <div class="dropdown">
                            <i class="fa fa-ellipsis-v dropdown-toggle" type="button" data-toggle="dropdown"
                                aria-expanded="false"></i>
                            <div class="dropdown-menu">
                                <a class="dropdown-item" href="{{ route('admin.inbox.details', $inbox->ref) }}">
                                    <i class="fa fa-eye"></i> View Details
                                </a>
                                <a class="dropdown-item" href="{{ route('admin.inbox.conversations', $inbox->ref) }}">
                                    <i class="fa fa-comments"></i> View Conversations
                                </a>
                                <a class="dropdown-item" href="#" @click="delete_inbox(@js($inbox->id))">
                                    <i class="fa fa-trash"></i> Delete
                                </a>
                            </div>
                        </div>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
        {{ $inboxes->links() }}
    </div>
    <div class="d-flex d-lg-none">
        <div>
            <label for="">from</label>
            <input type="date" wire:model="from_date" class="form-control">
        </div>
        &nbsp; &nbsp;
        <div>
            <label for="">to</label>
            <input type="date" wire:model="to_date" class="form-control">
        </div>
        @if ($from_date != '' && $to_date != '')
        <div class="d-block d-lg-none">
            <div>
                <button class="btn btn-sm btn-primary" wire:click='resetFilters'>reset
                    date</button>
            </div>
        </div>
        @endif
    </div>
    @else
    <div class="text-center py-5">
        <img src="{{ asset('dash/images/cloud-database-svgrepo-com.svg') }}" alt="no record found" class="img-fluid">

        @if ($search != '' || $status != 'All' || ($from_date != '' && $to_date != ''))
        <h1 class="mt-3 font-weight-bolder text-info">No Result found</h1>
        <p>We couldn't find what you are looking for. Try again.</p>
        <button type="button" class="btn btn-primary" wire:click='resetFilters'>
            Try again
        </button>
        @else
        <h1 class="mt-3 font-weight-bolder text-info">No Data found</h1>
        <p>
            You do not have any inboxes yet. <br> When your users place a
            withdrawal request, it will appear here.
        </p>
        @endif
    </div>
    @endif

    <script>
        document.addEventListener('alpine:init', () => {
            Alpine.data('manage_inboxes', () => ({
                delete_inbox(id) {
                    if (confirm(
                        'Are you sure you want to delete this inbox and its conversations?')) {
                        this.$wire.deleteInbox(id)
                    }
                }
            }))
        })
    </script>
</div>