<div>
    @if (session('success'))
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        {{ session('success') }}
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
    @endif

    <section>
        <div class="container py-5">

            <div class="row d-flex justify-content-center">
                <div class="col-md-10 col-lg-10 col-xl-10">
                    @if($inbox->status == 'closed')
                    <div class="alert alert-warning" role="alert">
                        <h4 class="alert-heading">Closed</h4>
                        <p class="mb-0">
                            This conversation has been ended. However, send a reply to reopen the conversation.
                        </p>
                    </div>
                    @endif

                    @if($inbox->status == 'open')
                    <a href="{{ route('close-inbox', $inbox->ref) }}" class="btn btn-warning btn-block"> Close
                        Conversation</a>
                    <br>
                    @endif
                    <div class="card" id="chat1" style="border-radius: 15px;">
                        <div class="bg-primary card-header d-flex justify-content-between align-items-center p-3 bg-primary text-white border-bottom-0"
                            style="border-top-left-radius: 15px; border-top-right-radius: 15px;">
                            <i class="fas fa-angle-left"></i>
                            <p class="mb-0 fw-bold">Reference : {{ $inbox->ref }}</p>
                        </div>
                        <div class="card-body">

                            @foreach($conversations as $conversation)

                            @php
                            $user = $conversation->inbox->user;
                            @endphp

                            @if($conversation->sender == 'user')
                            <div class="d-flex flex-row justify-content-start mb-4">
                                <img src='{{ $user->profile_photo_path ?? "https://ui-avatars.com/api/?background=fff1e3&rounded=true&color=000&name=$user->name" }}'
                                    alt="{{ $user->name }}" class="profile-image">
                                <div class="w-75 p-3 ms-3"
                                    style="border-radius: 15px; background-color: rgba(57, 192, 237,.2);">
                                    <p class="small mb-0">{{ $conversation->content }}</p>
                                </div>
                            </div>

                            @else

                            <div class="d-flex flex-row justify-content-end mb-4">
                                <div class="p-3 me-3 border bg-body-tertiary" style="border-radius: 15px;">
                                    <p class="small mb-0">{{ $conversation->content }}</p>
                                </div>
                                <img src="https://ui-avatars.com/api/?background=fff1e3&rounded=true&color=000&name=Admin"
                                    alt="avatar 1" class="profile-image">
                            </div>
                            @endif
                            @endforeach

                                <div class="form-outline">
                                    <x-form.textarea name="message" class="form-control bg-body-tertiary" rows="5"
                                        placeholder="Your Reply" wire:model="message" />

                                    <button class="btn btn-rounded btn-primary mt-3 w-100"
                                        wire:click.prevent="sendMessage">Send</button>
                                </div>

                        </div>
                    </div>

                </div>
            </div>

        </div>
    </section>

    <style>
        .profile-image {
            width: 50px;
            height: 50px;
            border-radius: 50%;
            object-fit: cover;
            border: 2px solid #ccc;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            margin: 2px;
        }

        #chat1 .form-outline .form-control~.form-notch div {
            pointer-events: none;
            border: 1px solid;
            border-color: #eee;
            box-sizing: border-box;
            background: transparent;
        }

        #chat1 .form-outline .form-control~.form-notch .form-notch-leading {
            left: 0;
            top: 0;
            height: 100%;
            border-right: none;
            border-radius: .65rem 0 0 .65rem;
        }

        #chat1 .form-outline .form-control~.form-notch .form-notch-middle {
            flex: 0 0 auto;
            max-width: calc(100% - 1rem);
            height: 100%;
            border-right: none;
            border-left: none;
        }

        #chat1 .form-outline .form-control~.form-notch .form-notch-trailing {
            flex-grow: 1;
            height: 100%;
            border-left: none;
            border-radius: 0 .65rem .65rem 0;
        }

        #chat1 .form-outline .form-control:focus~.form-notch .form-notch-leading {
            border-top: 0.125rem solid #39c0ed;
            border-bottom: 0.125rem solid #39c0ed;
            border-left: 0.125rem solid #39c0ed;
        }

        #chat1 .form-outline .form-control:focus~.form-notch .form-notch-leading,
        #chat1 .form-outline .form-control.active~.form-notch .form-notch-leading {
            border-right: none;
            transition: all 0.2s linear;
        }

        #chat1 .form-outline .form-control:focus~.form-notch .form-notch-middle {
            border-bottom: 0.125rem solid;
            border-color: #39c0ed;
        }

        #chat1 .form-outline .form-control:focus~.form-notch .form-notch-middle,
        #chat1 .form-outline .form-control.active~.form-notch .form-notch-middle {
            border-top: none;
            border-right: none;
            border-left: none;
            transition: all 0.2s linear;
        }

        #chat1 .form-outline .form-control:focus~.form-notch .form-notch-trailing {
            border-top: 0.125rem solid #39c0ed;
            border-bottom: 0.125rem solid #39c0ed;
            border-right: 0.125rem solid #39c0ed;
        }

        #chat1 .form-outline .form-control:focus~.form-notch .form-notch-trailing,
        #chat1 .form-outline .form-control.active~.form-notch .form-notch-trailing {
            border-left: none;
            transition: all 0.2s linear;
        }

        #chat1 .form-outline .form-control:focus~.form-label {
            color: #39c0ed;
        }

        #chat1 .form-outline .form-control~.form-label {
            color: #bfbfbf;
        }
    </style>
</div>