<form class="form" enctype="multipart/form-data" method="post" action="{{ route('submit-verification') }}">
    @csrf
    <x-widgets.modal id="kycForm" title="KYC">
        @if ($user->kyc)
        @if($user->kyc->status=='Verified')
            <div class="card">
                <div class="card-body text-primary">
                    Your KYC information has been verified successfully.
                </div>
            </div>
        @else
        <div class="card">
            <div class="card-body text-primary">
                Your KYC has been received and is under review.
            </div>
        </div>
        @endif
        @else
            <div class="row">
                <div class="col-md-6 col-6">
                    <div class="form-group">
                        <label for="recipient-name" class="col-form-label">Name:</label>
                        <x-form.input class="form-control"
                            id="recipient-name" name="name" value="{{ $user->name }}"
                            value="{{ old('name') }}" />
                    </div>
                </div>
                <div class="col-md-6 col-6">
                    <div class="form-group">
                        <label for="recipient-name" class="col-form-label">Date of Birth:</label>
                        <x-form.input type="date" class="form-control" id="recipient-name"
                            value="{{ old('dob') }}" name="dob" />
                    </div>
                </div>
                <div class="col-md-6 col-6">
                    <div class="form-group">
                        <label for="recipient-name" class="col-form-label">Country:</label>
                        <x-form.select name="country"
                            class="form-control">
                            @if (old('country'))
                                <option>{{ old('country') }}</option>
                            @endif
                            <option value="">Select a Country</option>
                            @include('auth.countries')
                        </x-form.select>
                    </div>
                </div>
                <div class="col-md-6 col-6">
                    <div class="form-group">
                        <label for="recipient-name" class="col-form-label">SSN(if US or Canada Citizen):</label>
                        <x-form.input class="form-control"
                            id="recipient-name" value="" name="ssn" />
                    </div>
                </div>
                <div class="col-md-6 col-lg-6">
                    <div class="form-group">
                        <label for="recipient-name" class="col-form-label">Occupation:</label>
                        <x-form.input class="form-control"
                            id="recipient-name" value="{{ old('occupation') }}" name="occupation" />
                    </div>
                </div>
                <div class="col-md-6 col-lg-6">
                    <div class="form-group">
                        <label for="recipient-name" class="col-form-label">ID type:</label>
                        <x-form.select name="id_type"
                            class="form-control">
                            <option value="">Select an Option</option>
                            <option>International Passport</option>
                            <option>Driver's Licence</option>
                            <option>National ID Card</option>
                        </x-form.select>
                    </div>
                </div>
                <div class="col-md-12 col-12">
                    <div class="form-group">
                        <label for="recipient-name" class="col-form-label">ID Image(Front view)</label>
                        <x-form.input class="form-control" id="recipient-name" name="front_image" type="file" />
                    </div>
                </div>
                <div class="col-md-12 col-12">
                    <div class="form-group">
                        <label for="recipient-name" class="col-form-label">ID Image(Back view)</label>
                        <x-form.input class="form-control" id="recipient-name" name="back_image" type="file" />
                    </div>
                </div>
                <div class="col-md-12 col-12">
                    <div class="form-group">
                        <label for="recipient-name" class="col-form-label">Selfie with ID</label>
                        <x-form.input class="form-control" id="recipient-name" name="selfie" type="file" />
                    </div>
                </div>
                <div class="col-12 text-center">
                    <button type="submit" class="btn btn-primary mr-1 mb-1">Verify</button>
                </div>
            </div>
        @endif
    </x-widgets.modal>
</form>
