@extends('layouts.base')

@section('title', 'Stocks') 

@section('content',)
<main>
    <div id="Hero" class="inner-hero" style="background-image:url(img/stock-bg.jpg)">
<div class="content-wrapper w-container">
    <div class="inner-hero-text">
        <div data-w-id="e28a7d76-aa9f-359f-47b4-3b9f188dc6dd"
            style="-webkit-transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);-moz-transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);-ms-transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);"
            class="title-white">PRODUCT</div>
        <h1 data-w-id="e28a7d76-aa9f-359f-47b4-3b9f188dc6df"
            style="-webkit-transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);-moz-transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);-ms-transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);"
            class="h1-title large">STOCKS <br /><span class="text-red"> </span><span class="text-red"></span><span
                class="text-red"></span></h1>
        <div data-w-id="ef20e734-d946-cab2-7ec9-d0c02b7cedf8"
            style="-webkit-transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);-moz-transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);-ms-transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);"
            class="bottom-border">
            <div class="_2-red-line _2-top-border"></div>
        </div>
        <p data-w-id="e28a7d76-aa9f-359f-47b4-3b9f188dc6e8"
            style="-webkit-transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);-moz-transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);-ms-transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);"
            class="subtitle-white"> </p>
    </div><a href="#Intro" data-w-id="e28a7d76-aa9f-359f-47b4-3b9f188dc6ea"
        style="-webkit-transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);-moz-transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);-ms-transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0)"
        class="scroll-down w-hidden-medium w-inline-block"></a>
</div>
</div>



<div id="Meals" data-w-id="951a5aea-0c94-bead-267a-f4d02c37cbb3" class="content-section-green">
<div class="content-wrapper w-container">
    <div class="flex">

        <div data-w-id="311e2a2e-91b9-3f0d-61de-29a5bdd9323c" class="_2-60-column">
            <div class="bottom-border">
                <div class="header-flex-stretch">
                    <div class="header-border-flex">
                        <h2 class="h2-title-green">What are stocks?
                        </h2>
                    </div>
                    <div class="_2-top-padding">
                        <div class="green-line"></div>
                    </div>
                </div>
            </div>
            <div>
                <p class="split-paragraph-green"><span class="capital-letter"></span><span
                        class="capital-letter">A</span> stock represents a share in the ownership of a company,
                    including a claim on the company's earnings and assets. As such, stockholders are partial
                    owners of the company. When the value of the business rises or falls, so does the value of
                    the stock.

                    Stocks are generally bought and sold electronically through stock exchanges, the two primary
                    ones in the United States being the New York Stock Exchange (NYSE) and the National
                    Association of Securities Dealers (NASDAQ). While some companies sell stock directly to
                    investors, most only sell stock through a brokerage such as Schwab.

                    Investors buy and sell stocks for a number of reasons including the potential to grow the
                    value of their investment over time, to potentially profit from shorter-term stock price
                    moves, or even to earn an income by investing in dividend-paying stocks. Keep in mind that
                    the price of a stock can fall as easily as it can rise. Investing in stock offers no
                    guarantee that you will make money, and many investors lose money instead.
                </p>


            </div>
            <div class="top-border">
            </div>
        </div>
    </div>
</div>
</div>




<div class="content-section">
<div class="content-wrapper w-container">

    <div class="row">
        <div class="col-md-6">
            <h2 class="h2-title">How stocks fit within an overall investment portfolio.</h2>
            <div class="_2-red-line"></div><br />
            <p style="color:black">
                Stocks are an important part of any portfolio because of their potential for growth and higher
                returns versus other investment products. In order to determine how much you should allocate to
                stocks, you should first develop a comprehensive financial plan that reflects your investment
                horizon and the level of risk you're willing to accept in exchange for the potential upside
                stocks can offer.
                <br /><br />
                Asset classes perform differently, and it's nearly impossible to predict which asset class will
                perform best in a given year. If you had invested $100,000 in just U.S. Stocks in 1997, it would
                have almost quadrupled to $400,000 by 2017, but there would have been many ups and downs due to
                volatility. A more diversified investment portfolio would have had a lower return, but reduced
                volatility.
            </p>
        </div>

        <div class="col-md-6">
            <img src="img/Elledge_181012.jpg" />
        </div>

    </div>



</div>
</div>




<div class="content-section">
<div class="content-wrapper w-container">

    <h2 class="h2-title">Types of stock</h2>
    <div class="_2-red-line"></div><br />
    <p style="color:black">Learn about three main types of stocks, as well as some potential advantages and
        considerations.</p>


    <table>
        <thead>
            <tr>
                <td style="padding:30px;  color:white">

                </td>

                <td style="padding:30px; background-color:#98A4AE; color:white">
                    <b>Common stock</b>
                </td>

                <td style="padding:30px; background-color:#98A4AE; color:white">
                    <b>Preferred stock</b>
                </td>

                <td style="padding:30px; background-color:#98A4AE; color:white">
                    <b>American Depositary Receipts (ADRs)</b>
                </td>


            </tr>

        </thead>
        <tbody>
            <tr>
                <td style="padding:20px">
                    <h2>Definition</h2>
                    <div class="_2-red-line"></div>
                </td>
                <td style="padding:20px; color:black">A stock represents a share in the ownership of a company,
                    including a claim on the company's earnings and assets. As such, stockholders are partial owners
                    of the company.
                    <br />
                    Fractional shares of stock also represent ownership of a company, but at a size smaller than a
                    full share of common stock.
                </td>
                <td style="padding:20px;color:black">Preferred stocks (or preferred securities) are hybrid
                    investments that share characteristics of both stocks and bonds. They can offer higher yields
                    than many traditional fixed income investments, but they come with different risks.</td>
                <td style="padding:20px;color:black">Many non-U.S. companies, that would otherwise be unavailable or
                    inconvenient to trade, do trade in the U.S. markets as ADRs (receipts for shares of the foreign
                    stock issued by U.S. banks). They are denominated in U.S. dollars and pay dividends in U.S.
                    dollars.</td>


            </tr>

            <tr>
                <td style="padding:20px">
                    <h2>Advantages</h2>
                    <div class="_2-red-line"></div>
                </td>
                <td style="padding:20px; color:black">Potential for higher long-term return.

                    Voting rights (does not apply to owners of fractional shares).

                    Liquidity depending on trading volume.
                </td>
                <td style="padding:20px; color:black">
                    <br />
                    Dividends are typically higher and fixed.

                    Share price experiences less volatility compared to common stock.

                    Preferred shareholders are more likely to recover at least part of their investment if company
                    goes bankrupt.
                </td>

                <td style="padding:20px; color:black">Local U.S.-based trading tends to be more liquid than local
                    foreign markets.

                    Investors may be able to access financial information more easily than if you invest directly
                    overseas. </td>



            </tr>


            <tr>
                <td style="padding:20px">
                    <h2>Considerations</h2>
                    <div class="_2-red-line"></div>
                </td>
                <td style="padding:20px; color:black">Dividends, if available, are often lower, variable, and not
                    guaranteed.

                    Stock price and dividend may experience more volatility than preferred stock.

                    More likely to lose investment if company goes bankrupt.
                </td>
                <td style="padding:20px; color:black">
                    <br />
                    Lower long-term growth potential, if any.

                    No voting rights in most cases.

                    Generally less liquid than common stock.
                </td>

                <td style="padding:20px;color:black">Exposure to fluctuations in a foreign company's local currency
                    could affect value of investment.

                    Political or economic events in a foreign company's home country could potentially harm your
                    investment. </td>



            </tr>




        </tbody>


    </table>

</div>
</div>




<div class="content-section">
<div class="content-wrapper w-container">

    <h2 class="h2-title">Why invest in stocks with {{ $settings->site_name }}?</h2>
    <div class="_2-red-line"></div><br />
    
    

    <style>
        .img-hover-zoom {
            /* [1.1] Set it as per your need */
            overflow: hidden;
            /* [1.2] Hide the overflowing of child elements */
        }

        /* [2] Transition property for smooth transformation of images */
        .img-hover-zoom img {
            transition: transform .5s ease;
        }

        /* [3] Finally, transforming the image when container gets hovered */
        .img-hover-zoom:hover img {
            transform: scale(1.5);
        }

    </style>

    <div class="row">
        <div class="col-md-3">
            <div class="img-hover-zoom">
                <img src="img/CP-Weekly-teaser.png" />
            </div>

            <h4 class="h4-title">$0 online equity commissions</h4>
            <div class="_2-red-line"></div>
            <br />
            <p style="color:black">No one is lower than Schwab among E*TRADE, Fidelity, or Vanguard </p>

        </div>

        <div class="col-md-3">
            <div class="img-hover-zoom">
                <img src="img/james_purcell_img_6564.jpg" />
            </div>

            <h4 class="h4-title">Intuitive platforms</h4>
            <div class="_2-red-line"></div>
            <br />
            <p style="color:black">Trade stocks using our web, mobile, or advanced platforms. </p>

        </div>


        <div class="col-md-3">
            <div class="img-hover-zoom">

                <img src="img/OBok3F8buKY.jpg" />
            </div>

            <h4 class="h4-title">Trading specialists</h4>
            <div class="_2-red-line"></div>
            <br />
            <p style="color:black">Get real-time trade analysis and focused support from investing professionals.
            </p>



        </div>


        <div class="col-md-3">
            <div class="img-hover-zoom">
                <img src="img/activeownership.jpg" />
            </div>

            <h4 class="h4-title">Premium research</h4>
            <div class="_2-red-line"></div>
            <br />
            <p style="color:black">Sharpen your instincts with actionable stock trading research and insights from
                Schwab and third parties.</p>


        </div>





    </div>



</div>
</div>



<div id="Section-1" class="_2-content-section" style="color:black">
<div class="content-wrapper w-container">
    <div data-w-id="6271dd51-e374-fe90-084e-bd7656de6c19" style="" class="heading-container">
        <div class="flex-header">
            <div class="heading-box">
                <div class="title"></div>
                <div class="content-wrapper"></div>
                <h2 class="h2-title">Why trade stocks? </h2>

                <p style="color:black">Stocks let you own a piece of a company’s future. They’re available for a
                    wide variety of
                    industries—so you can tap into your knowledge of specific businesses, or help you to
                    diversify your portfolio.</p>
            </div>
        </div>
        <div class="heading-box">

        </div>
    </div>



    <div class="row" style="margin-bottom:20px">

        <div class="col-md-3">
            <br /><br />
            <center>
                <img src="img/stock1.png" />
                <h3>Growth potential</h3>
                <p style="color:black">While stock performance changes over time, successful stocks can help your
                    money grow—at
                    times, they can even outrun inflation</p>
            </center>
        </div>


        <div class="col-md-3" style="color:black">
            <br /><br />
            <center>
                <img src="img/stock2.png" />
                <h3>Income</h3>
                <p style="color:black">Some stocks pay regular dividends—that’s income you can keep or reinvest</p>
            </center>
        </div>

        <div class="col-md-3" style="color:black">
            <br /><br />
            <center>
                <img src="img/stock3.png" />
                <h3>Flexibility</h3>
                <p style="color:black">Since stocks trade by the millions every day, you can move quickly when
                    you’re buying or
                    selling</p>
            </center>
        </div>


        <div class="col-md-3">
            <br /><br />
            <center>
                <img src="img/stock4.png" />
                <h3>Control</h3>
                <p style="color:black">You decide which company to invest in, when it’s time to buy, and when it’s
                    time to sell</p>
            </center>
        </div>



    </div>


    <br /><br />
    <div data-w-id="bfd2a1f4-e975-47fc-74d8-ca9fdbfe8d84" style="" class="split-column reverse">

        <div data-w-id="bfd2a1f4-e975-47fc-74d8-ca9fdbfe8d96" style="" class="_50-column circles">
            <div class="bottom-border medium">
                <div>

                </div>

            </div>

            <img src="img/Elledge_181012_3465_CIT.jpg" />



        </div>
        <div data-w-id="bfd2a1f4-e975-47fc-74d8-ca9fdbfe8d85" style="" class="_50-column-center">
            <div class="_77-column">
                <div class="bottom-border medium">
                    <div>

                    </div>

                </div>
                <div>
                    <h3>Fast facts</h3>


                    <ul>

                        <li>Stop and conditional orders may help protect your portfolio</li>
                        <li>The price-to-earning (P/E) ratio can help you identify value stocks </li>
                        <li>Compare earnings-per-share (EPS) between similar companies.</li>
                        <li>Market capitalization (market cap) is the dollar value of a company</li>
                        <li>Stock performance can fluctuate depending on market conditions</li>

                    </ul>


                </div>
            </div>
        </div>
    </div>
</div>
</div>







<div class="content-section">
<div class="content-wrapper w-container">
    <div>
        <div data-w-id="05b38fc4-72d2-ef54-f259-15a88d5faf3f" style="" class="heading-container">
            <div class="center-icon"></div>
            <div class="flex-header">
                <div class="line"></div>
                <div class="heading-box">
                    <h2 class="h2-title"> Top five dividend yielding stocks</h2>
                </div>
                <div class="line"></div>
            </div>
            <div class="subheading">

            </div>
        </div>

        <div class="flex-space">
            <div data-w-id="27a7b142-5ea1-f6b5-3fe7-9fe4d1d727c1" style="; cursor:pointer;"
                onclick="location='private-wealth'" class="pricing-box">
                <div class="pricing-title">
                    <div class="regular-title"> WHAT IS A DIVIDEND?</div>
                </div>
                <div class="pricing-border">
                    <div class="pricing-intro">
                        <div class="bottom-border small" style="color:black">

                            A dividend is a payment made by a corporation to its stockholders, usually out of its
                            profits. Dividends are typically paid regularly (e.g. quarterly) and made as a fixed
                            amount per share of stock.
                            <br />

                        </div>
                        <div class="bottom-border mini">
                            <div class="text-dark medium"></div>
                        </div>
                        <div class="text-small"></div>


                    </div>



                </div>
            </div>
            <div data-w-id="e5bb93e0-2b55-303c-5665-8b300af28ab1" style="; cursor:pointer;"
                onclick="location='multi-asset'" class="pricing-box _2">
                <div class="pricing-title">
                    <div class="regular-title"> THE BASICS OF STOCK SELECTION</div>
                </div>
                <div class="pricing-border">
                    <div class="pricing-intro">
                        <div class="bottom-border small" style="color:black">

                            Selecting stocks for investing and trading should not be a guessing game in today's
                            market. Join us as we review the basics of technical analysis and other stock selection
                            techniques you should know before buying a stock.
                        </div>
                        <div class="bottom-border mini">
                            <div class="text-dark medium">
                            </div>
                        </div>
                        <div class="text-small"></div>
                    </div>


                </div>
            </div>
            <div data-w-id="63d9f3ed-95e2-61f0-96da-2a9f8ab0efc9" style="; cursor:pointer;"
                onclick="location='renewable-power'" class="pricing-box no-border">
                <div class="pricing-title">
                    <div class="regular-title">WHAT TO KNOW BEFORE YOU BUY STOCKS</div>
                </div>
                <div class="pricing-border">
                    <div class="pricing-intro">
                        <div class="bottom-border small" style="color:black">

                            Placing a stock trade is about a lot more than pushing a button and entering your order.
                            This brief video can help you prepare before you open a position and develop a plan for
                            managing it.
                        </div>
                        <div class="bottom-border mini">
                            <div class="text-dark medium" style="text-transform:uppercase"></div>
                        </div>
                        <div class="text-small"></div>
                    </div>


                </div>
            </div>
        </div>


        <br /><br /><br />
    </div>
</div>
</div>




<style>
@media (min-width: 768px) {

    .l-section.theme-black,
    .l-section.theme-blue,
    .l-section.theme-green,
    .l-section.theme-grey,
    .l-section.theme-teal {
        padding: 6rem 0;
    }

}

.l-section--sm-bottom-spacing,
.l-section.theme-black,
.l-section.theme-blue,
.l-section.theme-green,
.l-section.theme-grey,
.l-section.theme-teal {
    padding-bottom: 4.5rem;
}

.l-section--bottom-left-svg {
    position: relative;
    padding-bottom: 9rem !important;
}

@media (min-width: 768px) {
    .l-section {
        padding: 5.25rem 0;
        width: 100%;
    }

}

.l-section {
    display: -webkit-box;
    display: -ms-flexbox;
    display: flex;
    -webkit-box-align: center;
    -ms-flex-align: center;
    align-items: center;
    -webkit-box-orient: vertical;
    -webkit-box-direction: normal;
    -ms-flex-direction: column;
    flex-direction: column;
}

.l-section {
    padding: 3rem 0;
    position: relative;

    margin-right: auto;
    margin-left: auto;
    width: 100%;
    z-index: 1;
}


.l-section.theme-black:before {
    background-color: #000;
}

.l-section.theme-black:before,
.l-section.theme-blue:before,
.l-section.theme-green:before,
.l-section.theme-grey:before,
.l-section.theme-teal:before {
    left: auto;
    right: unset;
}

.l-section.theme-black:before,
.l-section.theme-blue:before,
.l-section.theme-green:before,
.l-section.theme-grey:before,
.l-section.theme-teal:before {
    position: absolute;
    content: "";
    background-color: #f0f0f0;
    top: 0;
    bottom: 0;
    width: 100vw;
    height: 100%;
    z-index: -10;
    font-size: 0;

    right: auto;
}

.l-section .l-section-background {
    left: auto;
    right: unset;
}

.l-section .l-section-background {
    position: absolute;
    content: "";
    background-size: cover;
    top: 0;
    bottom: 0;
    width: 100vw;
    height: 100%;
    z-index: -10;

    right: auto;
}

.l-section.theme-black *,
.l-section.theme-blue *,
.l-section.theme-green *,
.l-section.theme-teal * {
    color: #fff;
}





@media (min-width: 768px) {
    .l-section--bottom-left-svg:after {
        -webkit-transform: none;
        transform: none;
    }

}

.l-section--bottom-left-svg:after {
    content: "";
    width: 100vw;
    height: 100%;
    bottom: 0;
    left: unset;
    position: absolute;
    background-image: url(img/corner-stripes-bottom.svg);
    background-position: 0 100%;
    background-repeat: no-repeat;
    z-index: -5;
    -webkit-transform: scaleY(.4);
    transform: scaleY(.4);
    -webkit-transform-origin: bottom left;
    transform-origin: bottom left;
}


.c-media-object {
    display: -webkit-box;
    display: -ms-flexbox;
    display: flex;
    -webkit-box-orient: vertical;
    -webkit-box-direction: normal;
    -ms-flex-direction: column;


    -ms-flex-pack: justify;
    justify-content: space-between;
    -webkit-box-align: center;
    -ms-flex-align: center;
    align-items: center;

    width: 55%;
    margin: 0 auto 3rem;
}

</style>


<div class="l-section theme-black l-section--bottom-left-svg">
<div class="l-section-background"
    style="background-image: url(img/quintet_counterpoint_midyear_webinar_banner.jpg);"></div>
<div class="c-media-object js-media-object c-media-object--rounded-image">
    <div class="c-media-object__col">

        <div class="c-media-object__title" style="opacity: 1; visibility: inherit; width:60%">As we work as a
            community to prepare for the impact of COVID-19, we wanted to share assure you {{ $settings->site_name }} is adhering to
            the current situation. The health and safety of our employees, customers, and communities are our
            primary concern.<br /><br /> We are taking all measures to ensure we manage to safely get through this
            fluid situation while continuing to serve our customers, partners, and employees effectively.
            <br /><br />
        </div>




        <div class="fr-view">
            <p><a class="c-call-to-action c-call-to-action--ghost title" href="https://www.bing.com/covid"
                    style="float:left;margin-right:10px; text-decoration:none; border-bottom:0.5px solid red">See
                    Covid-19 Update </a></p>
        </div>

        <br>
        <br>




    </div>
    <div class="c-media-object__col">

    </div>
</div>
</div>


</main>
@endsection
