@extends('layouts.base')

@section('title', 'Responsibility') 

@section('content')
<main>
    <div id="Hero" class="inner-hero" style="background-image:url(img/responsibility.jpg)">
<div class="content-wrapper w-container">
    <div class="inner-hero-text">
        <div
            
            class="title-white">long-term assets</div>
        <h1 data-w-id="e28a7d76-aa9f-359f-47b4-3b9f188dc6df"
            
            class="h1-title large">Corporate Responsibility <br /><span class="text-red"> </span><span
                class="text-red"></span><span class="text-red"></span><span class="text-red"></span></h1>
        <div data-w-id="5f38f251-d950-133c-5522-1bc8ff4bc11a"
            
            class="bottom-border">
            <div class="_2-red-line _2-top-border"></div>
        </div>
        <p data-w-id="e28a7d76-aa9f-359f-47b4-3b9f188dc6e8"
            
            class="subtitle-white"></p>
    </div><a href="#Intro" data-w-id="e28a7d76-aa9f-359f-47b4-3b9f188dc6ea"
        style="opacity:0;-webkit-transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);-moz-transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);-ms-transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0)"
        class="scroll-down w-inline-block"></a>
</div>
</div>


<div class="content-wrapper w-container" style="margin-top:10px">
<div class="row">
    <div class="col-md-3">
        <div style="border:solid #205AAC 0.5px; text-align:center; color:black; padding:10px ; height:120px; ">
            <h2 style="color:black">+10 years</h2>
            of experience in responsible and impact investing

        </div>
    </div>

    <div class="col-md-3">
        <div style="border:solid #205AAC 0.5px; text-align:center; color:black; padding:10px; height:120px; ">
            <h2 style="color:black">90%*</h2>
            of AUM** classified as Articles 8 & 9 under SFDR

        </div>
    </div>
    <div class="col-md-3">
        <div style="border:solid #205AAC 0.5px; text-align:center; color:black; padding:10px;  height:120px; ">
            <h2 style="color:black"> >8800</h2>
            issuers rated according to ESG criteria

        </div>
    </div>
    <div class="col-md-3">
        <div style="border:solid #205AAC 0.5px; text-align:center; color:black; padding:10px;  height:120px; ">
            <h2 style="color:black"> 100%</h2>
            of our core portfolio managers have access to ESG research and scores


        </div>
    </div>


</div>
</div>



<div class="content-wrapper w-container" style="margin-top:30px; color:black">

<div class="row">

    <div class="col-md-6">
        <h3 class="h2-title">What is responsible investing?</h3>
        <div class="_2-red-line"></div><br />
        At {{ $settings->site_name }}, we define responsible investing (RI) as an investment process that incorporates
        environmental, social and governance (ESG) factors into its approach. RI enables clients to align their
        investments with global megatrends that are changing the investment landscape. Issues such as increasing
        regulation, the growing need for risk mitigation and a heightened social conscience can be more
        effectively addressed by integrating ESG factors into the investment process.
        <br /><br />
        <h3 class="h2-title">Why is responsible investing important?</h3>
        <div class="_2-red-line"></div><br />
        ESG can allow firms to foster a meaningful change in the global economy, and in the communities in which
        we live and work. We believe that ESG analysis leads to more effective investment solutions that address
        global challenges and create sustainable value for our clients.
        <br /><br />
        The integration of ESG factors is used to enhance traditional financial analysis by identifying
        potential risks and opportunities beyond technical valuations, providing data on issues such as
        potential reputational risk or identifying firms which are adapting to meet new market challenges. It is
        important to note that the main objective of ESG integration remains financial performance.

    </div>

    <div class="col-md-6">
        <br /><br /><br /><br />
        <img src="img/image2x_3.jpg" />

    </div>




</div>



</div>




<section class=" content-section ">
<div class="content-wrapper w-container">


    <h2 class="h2-title ">Our approach to responsible investment</h2>
    <div class="_2-red-line"></div><br />

    <div class=" row">

        <div class="col-md-6" style="color:black">
            We offer a bespoke, discretionary service to the majority of our
            clients through investment managers, financial planners, or a
            combination of the two. Therefore, our responsible investment
            approach will be tailored to the individual needs and objectives
            of the client.


            <br /><br />

            <b>1. ESG integration</b> <br />
            We believe that high-quality companies which manage
            ESG risks and opportunities well will make attractive
            long-term investments. Our research team considers
            ESG factors when evaluating individual companies and
            when they assess fund managers. Through the use of
            Sustainalytics, a third-party provider of ESG data, material
            risks and opportunities are fed into traditional financial
            analysis and models for our ‘buy list’ stocks.
            <br /><br />
            Our research team address ESG issues in due diligence
            questionnaires for all funds considered for our buy list. The
            team also has a dedicated socially responsible investing
            (SRI) list for funds with a sustainability focus, and with
            restrictions on investment in harmful activities. The SRI list
            helps our investment managers select funds which aim
            to deliver attractive investment returns while contributing
            positively to global environmental and social challenges.
            <br /><br />
            <b>2. Ethical screening</b> <br />
            During suitability discussions with their investment
            manager, clients can choose to apply certain ethical
            screening criteria to their portfolio. Clients can select
            certain restrictions for direct holdings, and portfolios are
            then created and managed to reflect these restrictions
            <br /><br />
            <b>3. Engagement and stewardship</b> <br />
            Brewin Dolphin is committed to being a good steward
            of our clients’ investments, to enhance and protect their
            long-term value. We are supporters of the UK Stewardship
            Code and have a tier one rating for our engagement work.
            <br /><br />
            For each core holding, our research team will monitor and
            engage with company management on priority material
            issues that impact the value of our clients’ assets, which
            include material ESG issues. This can be done directly or via
            collective engagement with other shareholders.


        </div>

        <div class="col-md-6" style="color:black">

            <h2 class="h2-title "> Reporting </h2>
            <div class="_2-red-line"></div><br />
            We report on all of our stewardship, engagement and
            responsible investment activities at least annually. Details
            of these reports will be available on our website.

            <br /><br />

            <h2 class="h2-title "> Conflicts of interest</h2>
            <div class="_2-red-line"></div><br />
            Conflicts of interest may arise from our responsible investment
            activities. Any such conflicts will be recorded, considered,
            and dealt with in line with {{ $settings->site_name }} conflicts of interest
            policy. All colleagues are regularly trained to identify and
            address potential conflicts of interest.


            <br /><br />

            <h2 class="h2-title "> Approval and review</h2>
            <div class="_2-red-line"></div><br />
            This statement is intended to summarise {{ $settings->site_name }}
            approach to responsible investment. Overall responsibility for
            this approach is held by the Sustainability Committee, which
            reports to the Executive Committee.
            It was reviewed and approved by the Sustainability Committee
            in December 2020. Our responsible investment statement will
            be reviewed and updated at least annually

            <br /><br />
            <img src="img/ourcult--ure.jpg" />
            <br /><br />
        </div>





    </div>


</div>
</section>





<section id="Intro" class="content-section blue">
<div class="content-wrapper w-container">
    <div data-w-id="247f0273-c00d-52b1-7780-e5e790e5ccf6"
        >
        <div data-w-id="247f0273-c00d-52b1-7780-e5e790e5ccf7">
            <div class="center-icon"></div>
            <div class="flex-header">


                <h2 class="h2-title">Our ESG principles are embedded throughout our operations and help us
                    ensure that our business model will be sustainable well into the future.</h2>
                <div class="_2-red-line _2-top-border"></div>
                <br />


            </div>
            <br /><br />

            <div class="row">
                <div class="col-md-6" style="border-right: 0.5px solid black ; color:black">

                    <h4>Mitigate the impact of our operations on the environment</h4>
                    <div class="_2-red-line _2-top-border"></div>
                    <br />
                    <ul>
                        <li><b>Environmental stewardship</b>: Strive to minimize the environmental impact of our
                            operations and improve our efficient use of resources over time.</li>
                        <li><b>Net Zero Commitment</b>: Support the goal of net zero greenhouse gas (GHG)
                            emissions by 2050 or sooner.</li>
                    </ul>

                    <br /><br />

                    <h4>Ensure the well-being and safety of employees</h4>
                    <div class="_2-red-line _2-top-border"></div>
                    <br />
                    <ul>
                        <li><b>Employee well-being</b>: Meet or exceed all applicable labor laws and standards
                            in jurisdictions where we operate, which includes respecting human rights, offering
                            competitive wages and implementing nondiscriminatory hiring practices.</li>
                        <li><b>Health & safety</b>: Aim to have zero serious safety incidents within our
                            businesses by working toward implementing consistent health and safety principles
                            across the organization.</li>
                    </ul>

                </div>




                <div class="col-md-6" style="color:black">
                    <h4>Be good stewards in the communities in which we operate</h4>
                    <div class="_2-red-line _2-top-border"></div>
                    <br />
                    <ul>
                        <li><b>Community engagement</b>: Engage with community groups that might be affected by
                            our actions to ensure that their interests, safety and well-being are appropriately
                            integrated into our decision-making.</li>
                        <li><b>Philanthropy</b>: Encourage our employees to participate in the communities in
                            which we operate.</li>
                    </ul>

                    <br /><br />

                    <h4>Conduct business according to the highest ethical and legal/regulatory standards</h4>
                    <div class="_2-red-line _2-top-border"></div>
                    <br />
                    <ul>
                        <li><b>Governance, ethics, and fairness</b>: Operate with high ethical standards by
                            conducting business activities in compliance with applicable legal and regulatory
                            requirements, and with our Code of Business Conduct and Ethics.</li>
                        <li><b>Transparency</b>: Be accessible to our investors and stakeholders by being
                            responsive to requests for information and timely in our communication.</li>
                    </ul>



                </div>

            </div>


        </div>





    </div>
</div>
</section>



<section class="content-section " style="padding-left:80px; padding-right:80px; padding-top:80px">


<center>
    <h2 class="h2-title"> Key dimensions of our ESG assessment of corporations and countries</h2>
    <div class="_2-red-line _2-top-border"></div>

    <br /><br />
    <img src="img/esg-frame.jpg" />
</center>





</section>


<section class="content-section" style="padding-left:50px; padding-right:50px; padding-bottom:50px">

<center>
    <h2 class="h2-title">Integrating ESG considerations into our investment process</h2>
    <div class="_2-red-line _2-top-border"></div>
    <br />
</center>




<br /><br />

<div class="row">
    <div class="col-md-6" style="color:black">

        <p style="color:black">Our commitments include incorporating ESG factors into our investment decisions,
            starting with the
            due diligence of potential investments through to the exit process. We tailor ESG due diligence to
            each investment, and we create post-investment remediation plans for material ESG considerations.
            For all potential investments, we use internal experts and a variety of ESG frameworks to identify
            material ESG factors and utilize external consultants where appropriate. This analysis includes
            everything from ensuring environmental, legal and regulatory compliance to the identification of
            opportunities to add value or mitigate risk in our portfolio. Our investment teams use an ESG due
            diligence guideline to ensure consideration of material ESG risks and opportunities.
            <br /><br />
            These teams
            then provide a detailed memorandum to the Investment Committee outlining the merits of the
            transaction and disclosures relating to risks, including material ESG issues, and potential
            mitigation strategies. All investments made by {{ $settings->site_name }} must be approved by the Investment Committee
            and must incorporate ESG matters into their evaluation, including anti-bribery and corruption,
            health and safety, and other ESG considerations.
        </p>

        <img src="img/ab0-1.jpg" />
    </div>

    <div class="col-md-6" style="height:460px">
        <img src="img/aba0-0.jpg" />

    </div>

    <div class="col-md-6" style="color:black">
        <br /><br /><br />
        <p style="color:black">Upon company acquisition, we create a tailored integration plan to ensure that
            all material matters,
            including ESG risks and opportunities are prioritized. ESG risks and opportunities are actively
            managed by the portfolio companies with guidance from our in-house investment teams, primarily
            through representation on company boards and equivalent oversight bodies where all financial,
            operational, and strategic elements of the business are reported, considered, and where appropriate,
            <br /><br />
            approved. This allows us to draw on local expertise, which provides valuable insight given the wide
            range of asset types and locations in which we invest. Certain key performance indicators, such as
            serious safety incidents, are reported regularly to the applicable board or other oversight body.
        </p>



    </div>

</div>



</section>


<center>
<h2 class="h2-title">Responsible Investment Highlights</h2>
<div class="_2-red-line _2-top-border"></div>
<br />
</center>
<br />

<section class="_2-content-section">
<div class="content-wrapper w-container">





    <div class="row">
        <div class="col-md-4">
            <h2 class="title" style="font-size:60px; color:crimson">09</h2>
            <br />
            <b style="font-size:17px; color:crimson"> Driving Responsible Investment Across All Financial
                Markets</b>
            <p style="color:black">Responsible investment is no longer a niche pursuit, and in many ways is
                perfectly suited fro fixed income investment. </p>
        </div>

        <div class="col-md-4">
            <h2 class="title" style="font-size:60px; color:#4ebeda">16</h2>
            <br />
            <b style="font-size:17px; color:#4ebeda"> Developing Data to Support Analysis
                and Engagement </b>
            <p style="color:black">{{ $settings->site_name }} Prime rating aim to highlight ESGand climate risk to support better
                research and stewdardship, and to help build portfolios talioredto our client's interest. </p>

        </div>

        <div class="col-md-4">
            <h2 class="title" style="font-size:60px; color:darkblue">20</h2>
            <br />
            <b style="font-size:17px; color:darkblue"> Proactive Engagement on ESG Issues Data to Support
                Analysis
                and Engagement </b>

            <p style="color:black">in 2020, 90% of 1,210 engagements included ESG issues </p>

        </div>


        <center>
            <br />

            <img src="img/respon2.png" />

        </center>






        <div class="col-md-4">
            <h2 class="title" style="font-size:60px; color:crimson">40</h2>
            <br />
            <b style="font-size:17px; color:crimson"> Investing for impact</b>
            <p style="color:black">{{ $settings->site_name }} added over 2bn of impact bonds to client accounts in 2020. 187
                Client accounts at {{ $settings->site_name }} now have exposure to impact bonds </p>
        </div>

        <div class="col-md-4">
            <h2 class="title" style="font-size:60px; color:#4ebeda">41</h2>
            <br />
            <b style="font-size:17px; color:#4ebeda"> Seeing Through Impact Washing </b>
            <p style="color:black">Only 40% of the impact bonds we analzyed fully met our sustainability
                expectations in 2020</p>

        </div>

        <div class="col-md-4">
            <h2 class="title" style="font-size:60px; color:darkblue">44</h2>
            <br />
            <b style="font-size:17px; color:darkblue"> A Responsible Partner </b>

            <p style="color:black">{{ $settings->site_name }} is offering greater transparency around our opeations, with new
                diversity target for our workforce. </p>

        </div>

    </div>

</div>





</div>
</section>


<section class="_2-content-section">
<div class="content-wrapper w-container">
    <div>

        <div class="inner-wrapper">
            <div class="flex">
                <div data-w-id="7224aa7c-9829-6411-0583-9474bc81b269" 
                    class="_50-column center-flex">
                    <div class="right-padding large">
                        <div class="bottom-border small">
                            <div class="header-flex-stretch">
                                <div class="_2-header-border">
                                    <div class="left-border padding">
                                        <div class="circle-red _1">
                                            <div>1</div>
                                        </div>
                                    </div>
                                    <div class="bottom-border small">
                                        <div class="title"></div>
                                        <h4 class="h4-title">governance </h4>
                                        <div class="_2-red-line"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="side-padding">
                            <p style="color:black">We are always working to maintain sound governance practices
                                to ensure ongoing
                                investor confidence. This involves a continual review of how evolving
                                legislation, guidelines and best practices should be reflected in our approach.
                                For example, we have a zero-tolerance approach to bribery, including
                                facilitation payments, and all {{ $settings->site_name }} employees are mandated to complete an
                                in-depth anti-bribery and corruption (ABC) training seminar annually. {{ $settings->site_name }}
                                maintains an ethics hotline to report suspected unethical, illegal or unsafe
                                behavior. Our reporting hotline is managed by an independent third party and is
                                available 24 hours a day, 7 days a week. We also require all portfolio companies
                                in which we have a controlling interest to adopt an ABC policy that is equally
                                stringent to {{ $settings->site_name }}’s, which entails that portfolio companies install an
                                ethics hotline within six months of acquisition.</p>

                        </div>
                    </div>
                </div>
                <div class="_50-column center-flex">
                    <div data-w-id="649825e3-b2b9-a0e6-f6df-198152928ec8" class="_5-image-block"
                        style="background-image:url(img/respon1.jpg) !important"></div>
                </div>
            </div>


            <div data-w-id="3a2ea1ac-d60f-31b4-2acc-1d0828b1a04c" 
                class="full-line _2-less-border"></div>
            <div class="flex">
                <div class="_50-column center-flex">
                    <div data-w-id="154e65a3-a9f9-b032-45d0-5bc4c2770ed0" class="_5-image-block _2"
                        style="background-image:url(img/respon2.jpg) !important"></div>
                </div>
                <div data-w-id="154e65a3-a9f9-b032-45d0-5bc4c2770eba" 
                    class="_50-column center-flex">
                    <div class="left-padding large">
                        <div class="bottom-border small">
                            <div class="header-flex-stretch">
                                <div class="_2-header-border">
                                    <div class="left-border padding">
                                        <div class="circle-red _1">
                                            <div>2</div>
                                        </div>
                                    </div>
                                    <div class="bottom-border small">
                                        <div class="title"></div>
                                        <h4 class="h4-title">Health and safety in our portfolio companies</h4>
                                        <div class="_2-red-line"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="side-padding">
                            <p style="color:black">Employee health and safety is a top priority at {{ $settings->site_name }}. We
                                view health and
                                safety as an integral part of the management of our business and therefore
                                consider it a line responsibility best managed by portfolio companies. We have
                                established a safety steering committee, which includes the CEOs and COOs of
                                each business group, to promote common values and a strong health and safety
                                culture, share best practices and monitor serious safety incidents. In the event
                                that a serious incident does occur, {{ $settings->site_name }} conducts an in-depth investigation
                                to determine root causes and formulate remediation actions.</p>

                        </div>
                    </div>
                </div>
            </div>
            <div data-w-id="088998f1-0e84-21bd-8368-5a8c9c3506d4" 
                class="full-line _2-less-border"></div>
            <div class="flex">
                <div data-w-id="62ae522e-315d-734d-e4b3-64c3b2537089" 
                    class="_50-column center-flex">
                    <div>
                        <div class="bottom-border small">
                            <div class="header-flex-stretch">
                                <div class="_2-header-border">
                                    <div class="left-border padding">
                                        <div class="circle-red _1">
                                            <div>3</div>
                                        </div>
                                    </div>
                                    <div class="bottom-border small">
                                        <div class="title"></div>
                                        <h4 class="h4-title"> diversity & inclusion</h4>
                                        <div class="_2-red-line"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="side-padding">
                            <p style="color:black">Embedded in our culture is a commitment to advancing
                                diversity and inclusion
                                across our organization. This begins at recruitment, continues in leadership
                                training programs and is woven into our policies and procedures. As a global
                                firm, we know that the best ideas come from having people from different
                                backgrounds, perspectives, experiences and skills across all businesses, levels
                                of seniority and offices.
                                <br /><br />
                                Training programs set clear expectations for our leaders in terms of their role
                                in helping all team members achieve their potential. The training emphasizes
                                building trust with their teams, becoming aware of unconscious biases and
                                provides guidance on how to add rigor to decision-making especially in
                                recruiting, performance feedback and promotion, with the goal of creating a more
                                diverse and inclusive environment.
                                <br /><br />
                                Our internal groups and networks, including a global {{ $settings->site_name }} Women’s Advisory
                                Committee and a Diversity Advisory Committee, actively advise management on how
                                to make our Firm more welcoming to people from diverse backgrounds.
                            </p>

                        </div>
                    </div>
                </div>
                <div class="_50-column center-flex">
                    <div data-w-id="62ae522e-315d-734d-e4b3-64c3b253709f" class="_5-image-block _3"
                        style="background-image:url(img/respon3.jpg) !important "></div>
                </div>
            </div>
        </div>
        <div class="full-line _4-less-border"></div>





        <section class="content-section">
            <div class="content-wrapper w-container">

                <center>
                    <h4 class="h2-title">Areas of Focus </h4>
                    <div class="_2-red-line"></div>
                    <br />

                    <p style="color:black">{{ $settings->site_name }} is committed to advancing economic and social mobility for our
                        underserved communities by focusing on:</p>
                </center>
                {literal}
                <style>
                    .img-hover-zoom {
                        /* [1.1] Set it as per your need */
                        overflow: hidden;
                        /* [1.2] Hide the overflowing of child elements */
                    }

                    /* [2] Transition property for smooth transformation of images */
                    .img-hover-zoom img {
                        transition: transform .5s ease;
                    }

                    /* [3] Finally, transforming the image when container gets hovered */
                    .img-hover-zoom:hover img {
                        transform: scale(1.5);
                    }

                </style>
                {/literal}

                <div class="row">
                    <div class="col-md-3">
                        <div class="img-hover-zoom">
                            <img src="img/diversity_342x260.jpg" />
                        </div>

                        <h4 class="h4-title">WORKFORCE DEVELOPMENT</h4>
                        <div class="_2-red-line"></div>
                        <br />
                        <p style="color:black">Supporting vulnerable populations by partnering with organizations
                            that
                            provide professional development, life skills, and educational opportunities. </p>

                    </div>

                    <div class="col-md-3">
                        <div class="img-hover-zoom">
                            <img src="img/community_342x260.jpg" />
                        </div>

                        <h4 class="h4-title">EMPOWERING COMMUNITIES</h4>
                        <div class="_2-red-line"></div>
                        <br />
                        <p style="color:black">Partnering with organizations providing access to housing,
                            transportation and
                            those working to decrease the digital divide. </p>

                    </div>


                    <div class="col-md-3">
                        <div class="img-hover-zoom">

                            <img src="img/photo-collage-7.jpg" />
                        </div>

                        <h4 class="h4-title">EDUCATION & FINANCIAL LITERACY</h4>
                        <div class="_2-red-line"></div>
                        <br />
                        <p style="color:black">Fosters economic opportunities for youth by collaborating with
                            strategic
                            partners specializing in education and financial literacy.</p>



                    </div>


                    <div class="col-md-3">
                        <div class="img-hover-zoom">
                            <img src="img/health-wellness.jpg" />
                        </div>

                        <h4 class="h4-title">A SUSTAINABLE TOMORROW</h4>
                        <div class="_2-red-line"></div>
                        <br />
                        <p style="color:black">{{ $settings->site_name }} is committed to building sustainable, diverse and inclusive
                            organizations in communities
                            where we work and live.</p>


                    </div>





                </div>


                <br />



            </div>
        </section>




    </div>
</div>
</section>




{literal}


<style>
@media (min-width: 768px) {

    .l-section.theme-black,
    .l-section.theme-blue,
    .l-section.theme-green,
    .l-section.theme-grey,
    .l-section.theme-teal {
        padding: 6rem 0;
    }

}

.l-section--sm-bottom-spacing,
.l-section.theme-black,
.l-section.theme-blue,
.l-section.theme-green,
.l-section.theme-grey,
.l-section.theme-teal {
    padding-bottom: 4.5rem;
}

.l-section--bottom-left-svg {
    position: relative;
    padding-bottom: 9rem !important;
}

@media (min-width: 768px) {
    .l-section {
        padding: 5.25rem 0;
        width: 100%;
    }

}

.l-section {
    display: -webkit-box;
    display: -ms-flexbox;
    display: flex;
    -webkit-box-align: center;
    -ms-flex-align: center;
    align-items: center;
    -webkit-box-orient: vertical;
    -webkit-box-direction: normal;
    -ms-flex-direction: column;
    flex-direction: column;
}

.l-section {
    padding: 3rem 0;
    position: relative;

    margin-right: auto;
    margin-left: auto;
    width: 100%;
    z-index: 1;
}


.l-section.theme-black:before {
    background-color: #000;
}

.l-section.theme-black:before,
.l-section.theme-blue:before,
.l-section.theme-green:before,
.l-section.theme-grey:before,
.l-section.theme-teal:before {
    left: auto;
    right: unset;
}

.l-section.theme-black:before,
.l-section.theme-blue:before,
.l-section.theme-green:before,
.l-section.theme-grey:before,
.l-section.theme-teal:before {
    position: absolute;
    content: "";
    background-color: #f0f0f0;
    top: 0;
    bottom: 0;
    width: 100vw;
    height: 100%;
    z-index: -10;
    font-size: 0;

    right: auto;
}

.l-section .l-section-background {
    left: auto;
    right: unset;
}

.l-section .l-section-background {
    position: absolute;
    content: "";
    background-size: cover;
    top: 0;
    bottom: 0;
    width: 100vw;
    height: 100%;
    z-index: -10;

    right: auto;
}

.l-section.theme-black *,
.l-section.theme-blue *,
.l-section.theme-green *,
.l-section.theme-teal * {
    color: #fff;
}





@media (min-width: 768px) {
    .l-section--bottom-left-svg:after {
        -webkit-transform: none;
        transform: none;
    }

}

.l-section--bottom-left-svg:after {
    content: "";
    width: 100vw;
    height: 100%;
    bottom: 0;
    left: unset;
    position: absolute;
    background-image: url(img/corner-stripes-bottom.svg);
    background-position: 0 100%;
    background-repeat: no-repeat;
    z-index: -5;
    -webkit-transform: scaleY(.4);
    transform: scaleY(.4);
    -webkit-transform-origin: bottom left;
    transform-origin: bottom left;
}


.c-media-object {
    display: -webkit-box;
    display: -ms-flexbox;
    display: flex;
    -webkit-box-orient: vertical;
    -webkit-box-direction: normal;
    -ms-flex-direction: column;


    -ms-flex-pack: justify;
    justify-content: space-between;
    -webkit-box-align: center;
    -ms-flex-align: center;
    align-items: center;

    width: 55%;
    margin: 0 auto 3rem;
}

</style>
<div class="l-section theme-black l-section--bottom-left-svg">
<div class="l-section-background"
    style="background-image: url(img/quintet_counterpoint_midyear_webinar_banner.jpg);"></div>
<div class="c-media-object js-media-object c-media-object--rounded-image">
    <div class="c-media-object__col">

        <div class="c-media-object__title" style="opacity: 1; visibility: inherit; width:60%">As we work as a
            community to prepare for the impact of COVID-19, we wanted to share assure you {{ $settings->site_name }} is adhering to
            the current situation. The health and safety of our employees, customers, and communities are our
            primary concern.<br /><br /> We are taking all measures to ensure we manage to safely get through this
            fluid situation while continuing to serve our customers, partners, and employees effectively.
            <br /><br />
        </div>




        <div class="fr-view">
            <p><a class="c-call-to-action c-call-to-action--ghost title" href="https://www.bing.com/covid"
                    style="float:left;margin-right:10px; text-decoration:none; border-bottom:0.5px solid red">See
                    Covid-19 Update </a></p>
        </div>

        <br>
        <br>




    </div>
    <div class="c-media-object__col">

    </div>
</div>
</div>

</main>
@endsection
