@extends('layouts.base')

@section('title', 'Real Estate') 

@section('content')
<main>
        
    <div id="Hero" class="inner-hero"
        style="background-image:url(img/nyc_cityline_tiny.png); background-repeat: no-repeat; background-size: cover;">
        <div class="content-wrapper w-container">
            <div class="inner-hero-text">
                <div data-w-id="e28a7d76-aa9f-359f-47b4-3b9f188dc6dd"
                    style="-webkit-transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);-moz-transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);-ms-transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);"
                    class="title-white">Investment Products</div>
                <h1 data-w-id="e28a7d76-aa9f-359f-47b4-3b9f188dc6df"
                    style="-webkit-transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);-moz-transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);-ms-transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);"
                    class="h1-title large">Real <br /><span class="text-red">Estate </span><span
                        class="text-red"></span><span class="text-red"></span></h1>
                <div data-w-id="ef20e734-d946-cab2-7ec9-d0c02b7cedf8"
                    style="-webkit-transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);-moz-transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);-ms-transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);"
                    class="bottom-border">
                    <div class="_2-red-line _2-top-border"></div>
                </div>
                <p data-w-id="e28a7d76-aa9f-359f-47b4-3b9f188dc6e8"
                    style="-webkit-transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);-moz-transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);-ms-transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);"
                    class="subtitle-white"> </p>
            </div><a href="#Intro" data-w-id="e28a7d76-aa9f-359f-47b4-3b9f188dc6ea"
                style="-webkit-transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);-moz-transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);-ms-transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0)"
                class="scroll-down w-hidden-medium w-inline-block"></a>
        </div>
    </div>




    <div id="Meals" data-w-id="951a5aea-0c94-bead-267a-f4d02c37cbb3" class="content-section-green">
        <div class="content-wrapper w-container">
            <div class="flex">

                <div data-w-id="311e2a2e-91b9-3f0d-61de-29a5bdd9323c" class="_2-60-column">
                    <div class="bottom-border">
                        <div class="header-flex-stretch">
                            <div class="header-border-flex">
                                <h2 class="h2-title-green">Real Estate
                                </h2>
                            </div>
                            <div class="_2-top-padding">
                                <div class="green-line"></div>
                            </div>
                        </div>
                    </div>
                    <div>
                        <p class="split-paragraph-green"><span class="capital-letter"></span><span
                                class="capital-letter">A</span>s one of the world's largest investors in real estate, we
                            own and operate iconic properties in the world's most dynamic markets. Our global portfolio
                            includes office, retail, multifamily, logistics, hospitality, triple net lease, manufactured
                            housing and student housing assets on five continents. Our goal is to generate stable and
                            growing distributions for our investors while protecting them against downside risk. Our
                            assets are diversified by sector and geography, reducing exposure to movement in any single
                            market and minimizing volatility. In our public and private investment vehicles, we seek to
                            generate superior returns by leveraging our operating expertise and focusing on our core
                            real estate capabilities—leasing, financing, development, design and construction, and
                            property and facilities management. </p>


                    </div>
                    <div class="top-border">
                    </div>
                </div>
            </div>
        </div>
    </div>




    <section class="content-section">
        <div class="content-wrapper w-container" style="color:black">

            <div class="row">
                <div class="col-md-6">

                    {{ $settings->site_name }} Real Assets business is fully integrated with {{ $settings->site_name }} private equity and credit businesses
                    and
                    follows the same value-driven philosophy. Our experience in real estate principal investing, as
                    investor and
                    asset manager, spans market cycles and captures every level of the capital structure.
                    <br /><br />
                    Our Real Assets team provides deep knowledge and extensive industry relationships. We have offices
                    in North
                    America, Europe and Asia, and actively pursue investment opportunities in each region. {{ $settings->site_name }}
                    tackles
                    complexity to create value by thoughtfully identifying pockets of opportunity and relying on a
                    flexible
                    mandate to structure the best risk reward and rigorous asset management to maximize value.
                    <br /><br />
                </div>

                <div class="col-md-6">
                    <img src="img/iStock-91360378.jpg" />
                </div>

            </div>

            <br /><br />

            &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;
            <br /><br />
            <h3 class="h3-title">Real Estate Private Equity</h3>
            <div class="_2-red-line"></div>
            <br />
            {{ $settings->site_name }} real estate private equity business has a proven investment track record. It orients around
            thesis-driven strategies guided by the identification and analysis of disruptive forces, demographic trends,
            and market dislocations or pockets of distress. This enables us to invest across market cycles and
            sub-markets, and into both traditional and niche asset classes. Across the real estate private equity
            business, we employ an opportunistic, value-driven style and a flexible approach to acquire real estate
            assets, portfolios, and companies and provide servicing or structured credit solutions, through
            regionally-focused funds. {{ $settings->site_name }} looks for value in complex investments that most investors lack the
            inclination, resources, or ability to distill. We emphasize capital preservation and defensive positioning
            to build scalable platforms in partnership with strong, seasoned management teams.
            <br /><br />
            The real estate funds and accounts managed by {{ $settings->site_name }} invest in a broad spectrum of property types and
            throughout the capital structure.
            <br /><br />

            <h3 class="h3-title">Real Estate Equity Platform</h3>
            <div class="_2-red-line"></div>
            <br /><br />
            <img src="img/real1.png" />


            <h3 class="h3-title">Real Estate Credit</h3>
            <div class="_2-red-line"></div>
            <br />
            {{ $settings->site_name }}’s real estate debt platform manages and invests on behalf of {{ $settings->site_name }}’s public and private vehicles
            that invest in commercial real estate debt, including {{ $settings->site_name }} Commercial Real Estate Finance, Inc.
            (NYSE:ARI), a publicly traded commercial mortgage REIT. The funds we manage have originated and invested in
            commercial real estate debt opportunities across the spectrum, including mortgages, mezzanine loans,
            preferred equity and CMBS, across the United States and in Western Europe. Our comprehensive, balance
            sheet-style lending capabilities and deep relationships with repeat borrowers have earned {{ $settings->site_name }} a
            reputation as a flexible and efficient capital solutions provider.
            <br /><br />
            <h3 class="h3-title">{{ $settings->site_name }} Real Estate Debt Platform</h3>
            <div class="_2-red-line"></div>
            <br /><br />
            <img src="img/real2.png" />
        </div>
    </section>









    <div id="Section-1" class="_2-content-section">
        <div class="content-wrapper w-container">
            <div data-w-id="6271dd51-e374-fe90-084e-bd7656de6c19" style="" class="heading-container">
                <div class="flex-header">
                    <div class="heading-box">
                        <div class="title"></div>
                        <div class="content-wrapper"></div>
                        <h2 class="h2-title">Real Estate sectors</h2>
                    </div>
                </div>

            </div>

            
            <style>
                /* Style the tab */
                .tab {

                    Width: 500px;
                    background-color: #f1f1f1;
                    Color: black;

                }

                /* Style the buttons that are used to open the tab content */
                .tab button {
                    background-color: inherit;
                    float: left;
                    border: none;
                    outline: none;
                    cursor: pointer;
                    padding: 14px 16px;
                    transition: 0.3s;

                }

                /* Change background color of buttons on hover */
                .tab button:hover {
                    background-color: #ddd;
                }

                /* Create an active/current tablink class */
                .tab button.active {
                    background-color: #ccc;
                }

                /* Style the tab content */
                .tabcontent {
                    display: none;
                    padding: 6px 12px;

                    border-top: none;
                }

            </style>
            

            <div class="tab">
                <button class="tablinks" onclick="openCity(event, 'Office')" id="defaultOpen">Office</button>
                <button class="tablinks" onclick="openCity(event, 'Retail')">Retail</button>
                <button class="tablinks" onclick="openCity(event, 'Multifamily')">Multifamily</button>
                <button class="tablinks" onclick="openCity(event, 'Hospitality')">Hospitality</button>
                <button class="tablinks" onclick="openCity(event, 'Other')">Other</button>
            </div>
            <hr />
            <!-- Tab content -->
            <div id="Office" class="tabcontent">
                <div class="row">
                    <h3 class="title">Office</h3>

                    <div class="col-md-6">
                        <p style="color:black">
                            <br /><br />
                            We own, develop and manage office properties in key gateway cities in the U.S., Canada, the
                            U.K., Germany, Australia, Brazil, India and South Korea.
                        </p>
                        <br /><br />

                        <div class="intro-box">
                            <div class="bottom-border small-2"><a href="#" class="link-block w-inline-block">
                                    <h4 class="h4-title big" style="font-size:35px">318</h4>
                                </a>
                                <div class="_2-red-line"></div>
                            </div>
                            <p class="paragraph medium">PROPERTIES</p>
                        </div>

                        <br />

                        <div class="intro-box">
                            <div class="bottom-border small-2"><a href="#" class="link-block w-inline-block">
                                    <h4 class="h4-title big" style="font-size:35px">167M SF</h4>
                                </a>
                                <div class="_2-red-line"></div>
                            </div>
                            <p class="paragraph medium">COMMERCIAL SPACE</p>
                        </div>


                    </div>

                    <div class="col-md-6">

                        <br /><br />

                        <img src="img/potsdamerplatz_tiny.png" />


                    </div>




                </div>


            </div>

            <div id="Retail" class="tabcontent">


                <div class="row">
                    <br /><br />
                    <h3 class="title">Retail</h3>

                    <div class="col-md-6">
                        <p style="color:black">
                            <br /><br />
                            Our high-quality retail destinations are central gathering places for the communities they
                            serve, combining shopping, dining, entertainment and other activities.
                        </p>
                        <br /><br />

                        <div class="intro-box">
                            <div class="bottom-border small-2"><a href="#" class="link-block w-inline-block">
                                    <h4 class="h4-title big" style="font-size:35px">179</h4>
                                </a>
                                <div class="_2-red-line"></div>
                            </div>
                            <p class="paragraph medium">LOCATIONS, PREDOMINANTLY IN THE U.S</p>
                        </div>

                        <br />

                        <div class="intro-box">
                            <div class="bottom-border small-2"><a href="#" class="link-block w-inline-block">
                                    <h4 class="h4-title big" style="font-size:35px">154 million</h4>
                                </a>
                                <div class="_2-red-line"></div>
                            </div>
                            <p class="paragraph medium">TOTAL SQUARE FEET</p>
                        </div>


                    </div>

                    <div class="col-md-6">

                        <br /><br />

                        <img src="img/ggp_091614_shops_at_la_cantera_0454.jpg" />


                    </div>




                </div>


            </div>

            <div id="Multifamily" class="tabcontent">

                <div class="row">
                    <br /><br />
                    <h3 class="title">Multifamily</h3>

                    <div class="col-md-6">
                        <p style="color:black">
                            <br /><br />
                            Our extensive multifamily portfolio makes us one of the largest owners and managers of
                            residential apartment properties in the U.S. with ownership stakes in approximately 58,000
                            apartments.
                        </p>
                        <br /><br />

                        <div class="intro-box">
                            <div class="bottom-border small-2"><a href="#" class="link-block w-inline-block">
                                    <h4 class="h4-title big" style="font-size:35px">156</h4>
                                </a>
                                <div class="_2-red-line"></div>
                            </div>
                            <p class="paragraph medium">PROPERTIES</p>
                        </div>

                        <br />

                        <div class="intro-box">
                            <div class="bottom-border small-2"><a href="#" class="link-block w-inline-block">
                                    <h4 class="h4-title big" style="font-size:35px">51,595</h4>
                                </a>
                                <div class="_2-red-line"></div>
                            </div>
                            <p class="paragraph medium">APARTMENTS</p>
                        </div>


                    </div>

                    <div class="col-md-6">

                        <br /><br />

                        <img src="img/2716_4200_150113_rgb.png" />


                    </div>




                </div>


            </div>

            <div id="Hospitality" class="tabcontent">

                <div class="row">
                    <br /><br />
                    <h3 class="title">Hospitality</h3>

                    <div class="col-md-6">
                        <p style="color:black">
                            <br /><br />
                            We own and actively manage full-service hotels and leisure-style hospitality assets in
                            high-barrier markets across North America, the U.K. and Australia.
                        </p>
                        <br /><br />

                        <div class="intro-box">
                            <div class="bottom-border small-2"><a href="#" class="link-block w-inline-block">
                                    <h4 class="h4-title big" style="font-size:35px">16</h4>
                                </a>
                                <div class="_2-red-line"></div>
                            </div>
                            <p class="paragraph medium">FULL-SERVICE HOSPITALITY PROPERTIES</p>
                        </div>

                        <br />

                        <div class="intro-box">
                            <div class="bottom-border small-2"><a href="#" class="link-block w-inline-block">
                                    <h4 class="h4-title big" style="font-size:35px">140</h4>
                                </a>
                                <div class="_2-red-line"></div>
                            </div>
                            <p class="paragraph medium">EXTENDED-STAY HOTELS</p>
                        </div>

                        <div class="intro-box">
                            <div class="bottom-border small-2"><a href="#" class="link-block w-inline-block">
                                    <h4 class="h4-title big" style="font-size:35px">31,000</h4>
                                </a>
                                <div class="_2-red-line"></div>
                            </div>
                            <p class="paragraph medium">ROOMS</p>
                        </div>


                    </div>

                    <div class="col-md-6">

                        <br /><br />

                        <img src="img/high-res-jpg-center_parcs_stsp_exterior_night.jpg" />


                    </div>




                </div>

            </div>

            <div id="Other" class="tabcontent">

                <div class="row">
                    <br /><br />
                    <h3 class="title">Other</h3>

                    <div class="col-md-6">
                        <p style="color:black">
                            <br /><br />
                            We drive value in high-quality assets in other sectors such as logistics, triple net lease,
                            manufactured housing and student housing by focusing on leasing, financing, development,
                            construction and facilities management.
                        </p>
                        <br /><br />

                        <div class="intro-box">
                            <div class="bottom-border small-2"><a href="#" class="link-block w-inline-block">
                                    <h4 class="h4-title big" style="font-size:35px">159</h4>
                                </a>
                                <div class="_2-red-line"></div>
                            </div>
                            <p class="paragraph medium">STUDENT HOUSING PROPERTIES</p>
                        </div>

                        <br />

                        <div class="intro-box">
                            <div class="bottom-border small-2"><a href="#" class="link-block w-inline-block">
                                    <h4 class="h4-title big" style="font-size:35px">306</h4>
                                </a>
                                <div class="_2-red-line"></div>
                            </div>
                            <p class="paragraph medium">TRIPLE NET LEASE ASSETS</p>
                        </div>




                    </div>

                    <div class="col-md-6">

                        <br /><br />

                        <img src="img/2.1_uk_housing.jpg" />


                    </div>




                </div>




            </div>



        </div>

    </div>
    </div>

    </div>







    <section class="content-section">
        <div class="content-wrapper w-container" style="color:black">

            <h2 style="h2-title">Our Strategies</h2>
            <div class="_2-red-line"></div>

            <p>
                <br />
            <h3 style="title">Core/Core-Plus</h3>
            Our U.S. core/core-plus real estate strategy focuses on the acquisition of assets with strong long-term cash
            flow potential and durable tenancy diversified across end-user industries and geographies. Ares
            predominately targets industrial real estate in top-tier primary and regional distribution markets with an
            additional focus on other major sectors including multifamily, office, necessity-based retail and other
            select property types across the U.S. The strategy may also include small components of our Value-Add and
            Opportunistic strategies as described below.
            <br /><br />

            <h3 style="title">Value-Add </h3>
            Our U.S. and European value-add strategy focuses on undermanaged and under-funded income-producing assets,
            including multifamily, office, hotel, industrial, and mixed-use retail properties across the United States
            and Western Europe. The strategy seeks to create value and generate stable and growing distributions to
            investors by buying properties at attractive valuations, implementing asset management initiatives to
            increase income and identifying multiple exit strategies upfront.
            <br /><br />

            <h3 style="title">Opportunistic</h3>
            Our U.S. and European opportunistic real estate strategy capitalizes on increased investor demand for
            developed and stabilized assets by focusing on the repositioning of asserts, capitalization of distressed
            and special situations, and development of core-quality assets across all major property types including
            multifamily, hotel, office, retail and industrial properties throughout the United States and Europe.
            <br /><br />

            <img src="img/full_width_image2x_5.jpg" />
            <h1 class="title" style="font-size:32px; color:black">Targeted Investments</h1>
            <div class="row">
                <div class="col-md-6">
                    <h3>Real Estate Equity Strategies</h3>
                    Section8 Finance’s Real Estate Equity strategy is to focus on cash flowing quality assets
                    and de-risked developments with an opportunity to create value through repositioning, lease-up,
                    re-tenanting, redevelopment, and/or complex recapitalizations. Our strategy targets primary property
                    types located in liquid markets with diversified economies where we seek to deliver compelling, risk
                    adjusted returns through a combination of asset selectivity and disciplined portfolio management.
                    <br /><br />
                    Our Real Estate Group’s U.S. Equity platform implements real estate investment strategies that span
                    the risk spectrum, with a footprint in 10 cities.
                </div>
                <div class="col-md-6">

                    Our European Real Estate segment began in 1995. The investment team includes approximately 30
                    investment professionals with personnel based out of London, Paris and Luxembourg, with coverage of
                    Frankfurt, Madrid and Stockholm.
                    <br /><br />
                    Across the U.S. and Europe, we believe our teams have the experience to identify property types with
                    favorable risk adjusted returns in a given cycle, underwrite and execute these types of deals and
                    then monetize investments delivering attractive risk-adjusted returns to investors.

                </div>

            </div>


            </p>


        </div>
    </section>



    <section class="content-section">
        <div class="content-wrapper w-container" style="color:black">
            <h1 class="title" style="font-size:32px; color:black">Targeted Investments Characteristics</h1>
            <div class="_2-red-line"></div>

            <div class="row" style="margin-top:30px;">

                <div class="col-md-6">
                    <img src="img/image-12x_9.jpg" />
                </div>
                <div class="col-md-6">
                    <ul>
                        <li>Asset values of $10-250 million</li>
                        <li>Attractive basis with above-average supply/demand dynamics</li>
                        <li>Solid credit fundamentals</li>
                        <li>Strong market position with competitive economic advantage</li>
                        <li>Experienced, properly-incentivized sponsorship team with demonstrated track record</li>
                        <li>Appropriately structured and documented investment</li>
                        <li>Return opportunity that compensates for perceived risk</li>
                    </ul>

                </div>

            </div>








        </div>
    </section>


    <section class="content-section">
        <div class="content-wrapper w-container" style="color:black">
            <img src="img/full_width_image-12x.jpg" />
            <br />
            <h1 class="title" style="font-size:32px; color:black">Value Proposition</h1>
            <div class="_2-red-line"></div>

            <div class="row" style="margin-top:30px; ">
                <h2>Potential Benefits for our Investors:</h2>

                <div class="col-md-6" style="color:black; border-right:solid black 0.5px ;">
                    <ul style="color:black">
                        <li>
                            <p style="color:black">Alignment of interests with our investors</p>
                        </li>
                        <li>
                            <p style="color:black">Consistent, compelling performance across real estate equity and debt
                                strategies</p>
                        </li>
                        <li>
                            <p style="color:black">Dedicated and cycle-tested property professionals with local market
                                experience and relationship networks</p>
                        </li>
                        <li>
                            <p style="color:black">Complementary strategies to meet investor objectives across cycles
                            </p>
                        </li>
                    </ul>

                </div>
                <div class="col-md-6">
                    <ul>
                        <li>Synergistic Ares platform with a well-informed global view, access to relationships and
                            operational benefits</li>
                        <li>Stable and growing income and/or capital appreciation from investments</li>
                        <li>Disciplined growth with a focus on long-term value creation and capital preservation</li>
                    </ul>

                </div>

            </div>



        </div>
    </section>











    
    <style>
        @media (min-width: 768px) {

            .l-section.theme-black,
            .l-section.theme-blue,
            .l-section.theme-green,
            .l-section.theme-grey,
            .l-section.theme-teal {
                padding: 6rem 0;
            }

        }

        .l-section--sm-bottom-spacing,
        .l-section.theme-black,
        .l-section.theme-blue,
        .l-section.theme-green,
        .l-section.theme-grey,
        .l-section.theme-teal {
            padding-bottom: 4.5rem;
        }

        .l-section--bottom-left-svg {
            position: relative;
            padding-bottom: 9rem !important;
        }

        @media (min-width: 768px) {
            .l-section {
                padding: 5.25rem 0;
                width: 100%;
            }

        }

        .l-section {
            display: -webkit-box;
            display: -ms-flexbox;
            display: flex;
            -webkit-box-align: center;
            -ms-flex-align: center;
            align-items: center;
            -webkit-box-orient: vertical;
            -webkit-box-direction: normal;
            -ms-flex-direction: column;
            flex-direction: column;
        }

        .l-section {
            padding: 3rem 0;
            position: relative;

            margin-right: auto;
            margin-left: auto;
            width: 100%;
            z-index: 1;
        }


        .l-section.theme-black:before {
            background-color: #000;
        }

        .l-section.theme-black:before,
        .l-section.theme-blue:before,
        .l-section.theme-green:before,
        .l-section.theme-grey:before,
        .l-section.theme-teal:before {
            left: auto;
            right: unset;
        }

        .l-section.theme-black:before,
        .l-section.theme-blue:before,
        .l-section.theme-green:before,
        .l-section.theme-grey:before,
        .l-section.theme-teal:before {
            position: absolute;
            content: "";
            background-color: #f0f0f0;
            top: 0;
            bottom: 0;
            width: 100vw;
            height: 100%;
            z-index: -10;
            font-size: 0;

            right: auto;
        }

        .l-section .l-section-background {
            left: auto;
            right: unset;
        }

        .l-section .l-section-background {
            position: absolute;
            content: "";
            background-size: cover;
            top: 0;
            bottom: 0;
            width: 100vw;
            height: 100%;
            z-index: -10;

            right: auto;
        }

        .l-section.theme-black *,
        .l-section.theme-blue *,
        .l-section.theme-green *,
        .l-section.theme-teal * {
            color: #fff;
        }





        @media (min-width: 768px) {
            .l-section--bottom-left-svg:after {
                -webkit-transform: none;
                transform: none;
            }

        }

        .l-section--bottom-left-svg:after {
            content: "";
            width: 100vw;
            height: 100%;
            bottom: 0;
            left: unset;
            position: absolute;
            background-image: url(img/corner-stripes-bottom.svg);
            background-position: 0 100%;
            background-repeat: no-repeat;
            z-index: -5;
            -webkit-transform: scaleY(.4);
            transform: scaleY(.4);
            -webkit-transform-origin: bottom left;
            transform-origin: bottom left;
        }


        .c-media-object {
            display: -webkit-box;
            display: -ms-flexbox;
            display: flex;
            -webkit-box-orient: vertical;
            -webkit-box-direction: normal;
            -ms-flex-direction: column;


            -ms-flex-pack: justify;
            justify-content: space-between;
            -webkit-box-align: center;
            -ms-flex-align: center;
            align-items: center;

            width: 55%;
            margin: 0 auto 3rem;
        }

    </style>
    
    <div class="l-section theme-black l-section--bottom-left-svg">
        <div class="l-section-background"
            style="background-image: url(img/quintet_counterpoint_midyear_webinar_banner.jpg);"></div>
        <div class="c-media-object js-media-object c-media-object--rounded-image">
            <div class="c-media-object__col">

                <div class="c-media-object__title" style="opacity: 1; visibility: inherit; width:60%">As we work as a
                    community to prepare for the impact of COVID-19, we wanted to share assure you {{ $settings->site_name }} is adhering to
                    the current situation. The health and safety of our employees, customers, and communities are our
                    primary concern.<br /><br /> We are taking all measures to ensure we manage to safely get through this
                    fluid situation while continuing to serve our customers, partners, and employees effectively.
                    <br /><br />
                </div>




                <div class="fr-view">
                    <p><a class="c-call-to-action c-call-to-action--ghost title" href="https://www.bing.com/covid"
                            style="float:left;margin-right:10px; text-decoration:none; border-bottom:0.5px solid red">See
                            Covid-19 Update </a></p>
                </div>

                <br>
                <br>




            </div>
            <div class="c-media-object__col">

            </div>
        </div>
    </div>
    </main>
@endsection
