@extends('layouts.base')

@section('title', 'Investment Plans')

@section('content')
    <main>
        <div id="Hero" class="inner-hero" style="background-image:url(img/stock-bg.jpg)">
            <div class="content-wrapper w-container">
                <div class="inner-hero-text">
                    <div data-w-id="e28a7d76-aa9f-359f-47b4-3b9f188dc6dd"
                        style="-webkit-transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);-moz-transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);-ms-transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);"
                        class="title-white">Pricing</div>
                    <h1 data-w-id="e28a7d76-aa9f-359f-47b4-3b9f188dc6df"
                        style="-webkit-transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);-moz-transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);-ms-transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);"
                        class="h1-title large"><span class="text-red">Investment Plan</span><span
                            class="text-red"></span><span class="text-red"></span></h1>
                    <div data-w-id="ef20e734-d946-cab2-7ec9-d0c02b7cedf8"
                        style="-webkit-transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);-moz-transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);-ms-transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);"
                        class="bottom-border">
                        <div class="_2-red-line _2-top-border"></div>
                    </div>
                </div><a href="#Intro" data-w-id="e28a7d76-aa9f-359f-47b4-3b9f188dc6ea"
                    style=";-webkit-transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);-moz-transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);-ms-transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0)"
                    class="scroll-down w-hidden-medium w-inline-block"></a>
            </div>
        </div>
        <div style="background-color:#e6e6e6">
            <div style="padding:50px;max-width:1400px;margin:0 auto;">
                <div>
                    <h2 class="h2-title" style="text-align: center">Investment Plan
                    </h2>
                </div>
                <div style="display:flex;flex-wrap: wrap;">
                    @foreach ($plans as $plan)
                    <div class="pricing-table purple">
                        <!-- Table Head -->

                        <h2>{{ $plan->name }}</h2>
                        <h5>Minimum of {{ $plan->increment_amount }}% in {{ $plan->expiration }}</h5>
                        <!-- Features -->
                        <div class="pricing-features">
                            <div class="feature_1">Amount<span>${{ number_format($plan->min_price, 2) }} - ${{ number_format($plan->max_price, 2) }}</span></div>
                            <div class="feature_1">Minimum ROI<span>{{ $plan->increment_amount }}% {{ $plan->increment_interval }}</span></div>
                            <div class="feature_1">Affliate Commission<span>5%</span></div>
                        </div>
                        <!-- Price -->
                        <div class="price-tag">
                            <span class="symbol"></span>
                            <span class="amount">{{ $plan->increment_amount }}%</span>
                            <span class="after">/{{ $plan->increment_interval }}</span>
                        </div>
                        <!-- Button -->
                        <a class="price-button" href="{{ route('register') }}">Get Started</a>
                    </div>
                    @endforeach                   
                </div>

            </div>
        </div>


    </main>
@endsection
