@extends('layouts.base')

@section('title', 'Fixed Income') 

@section('content')
<main>
    <div id="Hero" class="inner-hero" style="background-image:url(img/fixed-bg.jpg)">
<div class="content-wrapper w-container">
    <div class="inner-hero-text">
        <div data-w-id="e28a7d76-aa9f-359f-47b4-3b9f188dc6dd"
            style="-webkit-transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);-moz-transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);-ms-transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);"
            class="title-white">PRODUCT</div>
        <h1 data-w-id="e28a7d76-aa9f-359f-47b4-3b9f188dc6df"
            style="-webkit-transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);-moz-transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);-ms-transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);"
            class="h1-title large">FIXED INCOME <br /><span class="text-red"> </span><span
                class="text-red"></span><span class="text-red"></span></h1>
        <div data-w-id="ef20e734-d946-cab2-7ec9-d0c02b7cedf8"
            style="-webkit-transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);-moz-transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);-ms-transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);"
            class="bottom-border">
            <div class="_2-red-line _2-top-border"></div>
        </div>
        <p data-w-id="e28a7d76-aa9f-359f-47b4-3b9f188dc6e8"
            style="-webkit-transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);-moz-transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);-ms-transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);"
            class="subtitle-white"> </p>
    </div><a href="#Intro" data-w-id="e28a7d76-aa9f-359f-47b4-3b9f188dc6ea"
        style=";-webkit-transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);-moz-transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);-ms-transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0);transform:translate3d(0, 50PX, 0) scale3d(1, 1, 1) rotateX(0) rotateY(0) rotateZ(0) skew(0, 0)"
        class="scroll-down w-hidden-medium w-inline-block"></a>
</div>
</div>



<div id="Meals" data-w-id="951a5aea-0c94-bead-267a-f4d02c37cbb3" class="content-section-green">
<div class="content-wrapper w-container">
    <div class="flex">

        <div data-w-id="311e2a2e-91b9-3f0d-61de-29a5bdd9323c" class="_2-60-column">
            <div class="bottom-border">
                <div class="header-flex-stretch">
                    <div class="header-border-flex">
                        <h2 class="h2-title-green">Fixed Income
                        </h2>
                    </div>
                    <div class="_2-top-padding">
                        <div class="green-line"></div>
                    </div>
                </div>
            </div>
            <div>
                <p class="split-paragraph-green"><span class="capital-letter"></span><span
                        class="capital-letter">W</span>e aim to generate consistent outperformance by
                    systematically applying investment themes across securities. We believe that a multi-factor
                    investment approach, harnessing underlying drivers of performance, will generate excess
                    returns that are uncorrelated to other asset classes as well as traditional fixed income
                    managers.
                </p>


            </div>
            <div class="top-border">
            </div>
        </div>
    </div>
</div>
</div>








<div id="Section-1" class="_2-content-section">
<div class="content-wrapper w-container">
    <div data-w-id="6271dd51-e374-fe90-084e-bd7656de6c19" style="" class="heading-container">
        <!-- <div class="flex-header">
            <div class="heading-box">
                <div class="title"></div>
                <div class="content-wrapper"></div>
                <h2 class="h2-title">Why trade stocks?</h2>
                <div class="center-flex">
                    <div class="red-line"></div>
                </div>
                <p style="color:black">Stocks let you own a piece of a company’s future. They’re available for a wide variety of
                    industries—so you can tap into your knowledge of specific businesses, or help you to
                    diversify your portfolio.</p>
            </div>
        </div> -->
        <div class="heading-box">

        </div>
    </div>


    <br /><br />
    <div data-w-id="bfd2a1f4-e975-47fc-74d8-ca9fdbfe8d84" style="" class="split-column reverse">

        <div data-w-id="bfd2a1f4-e975-47fc-74d8-ca9fdbfe8d96" style="" class="_50-column circles">
            <div class="bottom-border medium">
                <div>

                </div>

            </div>

            <h3 class="h2-title">Emerging Markets Hard Currency
                <div class="flex">
                    <div class="red-line"></div>
                </div>

            </h3>

            <p style="color:black">Seeks excess returns through country, maturity, and currency selection across
                hard currency and
                local currency markets. While the strategy includes local currency investments, it takes no beta
                to local currency debt, engages in no overall duration or spread timing, and targets a beta of
                one to its hard currency benchmark.</p>
            <br />
            <h3 class="h3-title">Global Aggregate</h3>
            <div class="flex">
                <div class="red-line"></div>
            </div>
            <br />
            <p style="color:black">
                Seeks excess returns through country, maturity, credit, and currency selection. The strategy targets
                the credit and duration profile of the benchmark and so does not seek to engage in duration timing
                or sector selection. </p>




        </div>
        <div data-w-id="bfd2a1f4-e975-47fc-74d8-ca9fdbfe8d85" style="" class="_50-column-center">
            <img src="img/barmfort_190318_3483_.jpg" />
        </div>
    </div>


    <div data-w-id="bfd2a1f4-e975-47fc-74d8-ca9fdbfe8d84" style="" class="split-column reverse">

        <div data-w-id="bfd2a1f4-e975-47fc-74d8-ca9fdbfe8d96" style="" class="_50-column circles">
            <div class="bottom-border medium">
                <div>

                </div>

            </div>

            <img src="img/Venture%20Capital%20Finance-lledge_160831_3332.html" />


        </div>
        <div data-w-id="bfd2a1f4-e975-47fc-74d8-ca9fdbfe8d85" style="" class="_50-column-center">
            <div class="_77-column">
                <div class="bottom-border medium">
                    <div>

                    </div>

                </div>
                <div>
                    <h3 class="h2-title">Global Governments <br />
                        <div class="flex">
                            <div class="red-line"></div>
                        </div>
                    </h3>


                    <p style="color:black">
                        This strategy seeks excess returns through country, maturity, and currency selection. It
                        engages in minimal duration timing. </p>
                    <br /><br />
                    <h3 class="h3-title">High Yield Corporates</h3>
                    <div class="flex">
                        <div class="red-line"></div>
                    </div>
                    <br />
                    <p style="color:black">
                        Investment themes in this strategy are primarily expressed by within-industry security
                        selection. It does not seek to engage in duration or credit timing.</p>




                </div>
            </div>
        </div>
    </div>
</div>
</div>









<div class="content-section">
<div class="content-wrapper w-container">




    <style>
        .img-hover-zoom {
            /* [1.1] Set it as per your need */
            overflow: hidden;
            /* [1.2] Hide the overflowing of child elements */
        }

        /* [2] Transition property for smooth transformation of images */
        .img-hover-zoom img {
            transition: transform .5s ease;
        }

        /* [3] Finally, transforming the image when container gets hovered */
        .img-hover-zoom:hover img {
            transform: scale(1.5);
        }

    </style>

    <div class="row">
        <div class="col-md-4">
            <div class="img-hover-zoom">
                <img src="img/Venture%20Capital%20Finance-iStock-943292690.html" />
            </div>

            <h4 class="h4-title">INVESTMENT GRADE CORPORATES</h4>
            <div class="_2-red-line"></div>
            <br />
            <p style="color:black">Seeks to outperform a core or long duration corporate benchmark. Our investment
                themes are primarily expressed by within-industry security selection. The strategy does not seek to
                engage in duration or credit timing. </p>

        </div>

        <div class="col-md-4">
            <div class="img-hover-zoom">
                <img src="img/Venture%20Capital%20Finance-iStock-1000636056.html" />
            </div>

            <h4 class="h4-title">UNCONSTRAINED BONDS</h4>
            <div class="_2-red-line"></div>
            <br />
            <p style="color:black">A cash-benchmarked bond strategy that seeks to deliver positive absolute returns
                with low correlation to traditional market betas. The strategy primarily utilizes a broad suite of
                relative value fixed income sub-strategies spanning interest rates, credit, and foreign exchange
                markets. It also includes a small, dynamic, and diversified allocation to fixed income market risks
                such as duration, credit, and securitized exposures. </p>

        </div>


        <div class="col-md-4">
            <div class="img-hover-zoom">

                <img src="img/Venture%20Capital%20Finance-32989328.html" />
            </div>

            <h4 class="h4-title">CORE PLUS</h4>
            <div class="_2-red-line"></div>
            <br />
            <p style="color:black">Strategy that seeks excess returns through country, maturity, credit, and
                currency selection. Out-of-benchmark sectors are strictly used to increase security selection
                breadth, while still targeting the credit and duration profile of the benchmark, and so does not
                seek to engage in duration timing or sector selection.</p>



        </div>








    </div>



</div>
</div>








<div id="Intro" class="content-section">
<div class="content-wrapper w-container">
    <div class="row" style="color:black">

        <h2 class="h2-title" style="font-size:22px">TYPES OF FIXED INCOME FUNDS <br />
            <div class="flex">
                <div class="red-line"></div>
            </div>
        </h2>


        There are a number of different types of income-producing funds, each with its own characteristics and
        level of risk.
        <br /><br /> <br /><br />
        <div class="col-md-6" style="margin-bottom:25px">
            <h4 class="h3-title">Government</h4>
            <div class="flex">
                <div class="red-line"></div>
            </div>
            <br />
            These funds typically invest in bonds issued by sovereign governments and government agencies
            authorized to issue debt, such as Fannie Mae and Freddie Mac, and international agencies, such as
            the World Bank and International Monetary Fund.
        </div>
        <div class="col-md-6" style="margin-bottom:25px">
            <h4 class="h3-title">Municipal Bonds </h4>
            <div class="flex">
                <div class="red-line"></div>
            </div>
            <br />
            Municipal bonds are issued by state and local governments in the U.S. in addition to other public
            authorities, such as school districts. Generally speaking, interest on municipal bonds is exempt
            from federal income taxes. In some states, interest on bonds issued by that state and the
            municipalities within it are also exempt from that state’s income taxes.
        </div>
        <div class="col-md-6" style="margin-bottom:25px">
            <h4 class="h3-title">Corporate Credit</h4>
            <div class="flex">
                <div class="red-line"></div>
            </div>
            <br />
            These funds typically invest in bonds, preferred stocks, and other types of fixed-income instruments
            representing debt issued by private corporations. Corporate bonds tend to be more risky than bonds
            issued by governments and carry various credit risks depending on the individual issuer. As a
            result, however, they may offer potentially higher income opportunities.

            <br /><br /><br /><br />

            <img src="img/Venture%20Capital%20Finance-5059c05dc7d20841f64344f8.html" />
        </div>
        <div class="col-md-6" style="margin-bottom:25px">
            <h4 class="h3-title">Multi-Sector</h4>
            <div class="flex">
                <div class="red-line"></div>
            </div>
            <br />
            These funds typically invest in a variety of fixed-income instruments, including a mix of government
            and corporate bonds. This provides investors with an additional level of diversification across both
            credit risk and price.
        </div>

        <br /><br />

        <div class="col-md-6" style="margin-bottom:25px">
            <h4 class="h3-title">Securitized</h4>
            <div class="flex">
                <div class="red-line"></div>
            </div>
            <br />
            Asset-backed securities are collateralized by loans that provide an income stream comprised of both
            principal and interest on the securities. Loans backing these securities include residential and
            commercial mortgages, automobile loans, credit cards, and other types of financial assets.
        </div>

        <div class="col-md-6" style="margin-bottom:25px">
            <h4 class="h3-title">Bank Loans </h4>
            <div class="flex">
                <div class="red-line"></div>
            </div>
            <br />
            These represent participation in loans to private corporations underwritten by commercial banks,
            including first lien, second lien, and collateralized loan obligations. Bank loans tend to be more
            risky than corporate bonds but, as a result, can potentially offer higher interest rates.
        </div>
        <div class="col-md-6" style="margin-bottom:25px">
            <h4 class="h3-title">Currencies</h4>
            <div class="flex">
                <div class="red-line"></div>
            </div>
            <br />
            These funds typically invest in money market instruments and forward currency contracts denominated
            in the currencies of foreign countries. In addition to carrying credit risk, these funds carry
            currency fluctuation risk.
        </div>





    </div>
</div>
</div>



<div id="Intro" class="content-section">
<div class="content-wrapper w-container">


    <div data-w-id="bfd2a1f4-e975-47fc-74d8-ca9fdbfe8d84" style="" class="split-column reverse">

        <div data-w-id="bfd2a1f4-e975-47fc-74d8-ca9fdbfe8d96" style="" class="_50-column circles">
            <div class="bottom-border medium">
                <div>


                </div>

            </div>

            <h3 class="h2-title">EMPHASIZE INDEPENDENT RESEARCH</h3>
            <div class="flex">
                <div class="red-line"></div>
            </div>
            <br />
            <p style="color:black">
                We focus on sectors where we believe our independent research offers the greatest opportunities
                to add value for our clients.</p>

            <h3 class="h2-title">UTILIZE MULTIPLE RESEARCH PERSPECTIVES</h3>
            <div class="flex">
                <div class="red-line"></div>
            </div><br />
            <p style="color:black">

                We believe fixed income portfolios can best be managed by integrating three perspectives: top-down
                macro analysis, bottom-up sector analysis and quantitative insights to guide strategy allocations.
            </p>




        </div>
        <div data-w-id="bfd2a1f4-e975-47fc-74d8-ca9fdbfe8d85" style="" class="_50-column-center">
            <div class="_77-column">
                <div class="bottom-border medium">
                    <div>

                    </div>

                </div>
                <div>

                    <img src="img/Venture%20Capital%20Finance-50a2ae18c1e7edd89faa3b.html" />




                </div>
            </div>
        </div>
    </div>





    <div data-w-id="bfd2a1f4-e975-47fc-74d8-ca9fdbfe8d84" style="" class="split-column reverse">

        <div data-w-id="bfd2a1f4-e975-47fc-74d8-ca9fdbfe8d96" style="" class="_50-column circles">
            <div class="bottom-border medium">
                <div>
                    <br />
                    <img src="img/Venture%20Capital%20Finance-trading-Simulation-Citadel.html" />
                </div>

            </div>






        </div>
        <div data-w-id="bfd2a1f4-e975-47fc-74d8-ca9fdbfe8d85" style="" class="_50-column-center">
            <div class="_77-column">
                <div class="bottom-border medium">
                    <div>

                    </div>

                </div>
                <div>

                    <h3 class="h2-title">COMMIT TO THE LONG TERM</h3>
                    <div class="flex">
                        <div class="red-line"></div>
                    </div>
                    <br />
                    <p style="color:black">
                        We take a long-term view for all we do, from the people we hire, to the markets we
                        enter, to the solutions we offer and to the investment decisions we make.
                    </p>

                    <h3 class="h2-title">OUR APPROACH</h3>
                    <p style="color:black">
                        We believe global fixed income markets are inefficient. In our view, the best way to
                        seek to exploit these inefficiencies is through a sector-by-sector research-oriented
                        approach, which is integrated globally. We offer investors a wide range of strategies
                        covering benchmark-aware and unconstrained to tailor portfolios that seek to meet a
                        diverse set of client needs </p>




                </div>
            </div>
        </div>
    </div>







    <div id="Intro" class="content-section">
        <div class="content-wrapper w-container" style="color:black">
            <h3> Manage Risk and Hedge against Loss with Fixed Products</h3>
            <div class="flex">
                <div class="red-line"></div>
            </div>
            <br />
            Fixed income investments offer long-term stability while generating higher returns than a
            traditional savings account. This makes them ideal for retirement accounts, short-term savings and
            as a diversification tool in any portfolio.
            <br /><br />
            <h3>Why Fixed Products? </h3>
            Fixed income investment products are an important part of many portfolios. Their opportunities for
            use are diverse and can help investors by:
            <br /><br />
            <ul>
                <li>Acting as a hedge against market volatility and downside risk. Creating a low-risk safe
                    haven for those investors with a low tolerance for risk.</li>
                <li>Providing a method of portfolio diversification.</li>
                <li>Allowing for a guaranteed return for short-term savings.</li>
                <li>Delivering a means to preserve retirement assets once an investor reaches retirement age.
                </li>
            </ul>
            <br /><br />
        </div>
    </div>



</div>
</div>



<style>
@media (min-width: 768px) {

    .l-section.theme-black,
    .l-section.theme-blue,
    .l-section.theme-green,
    .l-section.theme-grey,
    .l-section.theme-teal {
        padding: 6rem 0;
    }

}

.l-section--sm-bottom-spacing,
.l-section.theme-black,
.l-section.theme-blue,
.l-section.theme-green,
.l-section.theme-grey,
.l-section.theme-teal {
    padding-bottom: 4.5rem;
}

.l-section--bottom-left-svg {
    position: relative;
    padding-bottom: 9rem !important;
}

@media (min-width: 768px) {
    .l-section {
        padding: 5.25rem 0;
        width: 100%;
    }

}

.l-section {
    display: -webkit-box;
    display: -ms-flexbox;
    display: flex;
    -webkit-box-align: center;
    -ms-flex-align: center;
    align-items: center;
    -webkit-box-orient: vertical;
    -webkit-box-direction: normal;
    -ms-flex-direction: column;
    flex-direction: column;
}

.l-section {
    padding: 3rem 0;
    position: relative;

    margin-right: auto;
    margin-left: auto;
    width: 100%;
    z-index: 1;
}


.l-section.theme-black:before {
    background-color: #000;
}

.l-section.theme-black:before,
.l-section.theme-blue:before,
.l-section.theme-green:before,
.l-section.theme-grey:before,
.l-section.theme-teal:before {
    left: auto;
    right: unset;
}

.l-section.theme-black:before,
.l-section.theme-blue:before,
.l-section.theme-green:before,
.l-section.theme-grey:before,
.l-section.theme-teal:before {
    position: absolute;
    content: "";
    background-color: #f0f0f0;
    top: 0;
    bottom: 0;
    width: 100vw;
    height: 100%;
    z-index: -10;
    font-size: 0;

    right: auto;
}

.l-section .l-section-background {
    left: auto;
    right: unset;
}

.l-section .l-section-background {
    position: absolute;
    content: "";
    background-size: cover;
    top: 0;
    bottom: 0;
    width: 100vw;
    height: 100%;
    z-index: -10;

    right: auto;
}

.l-section.theme-black *,
.l-section.theme-blue *,
.l-section.theme-green *,
.l-section.theme-teal * {
    color: #fff;
}





@media (min-width: 768px) {
    .l-section--bottom-left-svg:after {
        -webkit-transform: none;
        transform: none;
    }

}

.l-section--bottom-left-svg:after {
    content: "";
    width: 100vw;
    height: 100%;
    bottom: 0;
    left: unset;
    position: absolute;
    background-image: url(img/corner-stripes-bottom.svg);
    background-position: 0 100%;
    background-repeat: no-repeat;
    z-index: -5;
    -webkit-transform: scaleY(.4);
    transform: scaleY(.4);
    -webkit-transform-origin: bottom left;
    transform-origin: bottom left;
}


.c-media-object {
    display: -webkit-box;
    display: -ms-flexbox;
    display: flex;
    -webkit-box-orient: vertical;
    -webkit-box-direction: normal;
    -ms-flex-direction: column;


    -ms-flex-pack: justify;
    justify-content: space-between;
    -webkit-box-align: center;
    -ms-flex-align: center;
    align-items: center;

    width: 55%;
    margin: 0 auto 3rem;
}

</style>
<div class="l-section theme-black l-section--bottom-left-svg">
<div class="l-section-background"
    style="background-image: url(img/quintet_counterpoint_midyear_webinar_banner.jpg);"></div>
<div class="c-media-object js-media-object c-media-object--rounded-image">
    <div class="c-media-object__col">

        <div class="c-media-object__title" style="opacity: 1; visibility: inherit; width:60%">As we work as a
            community to prepare for the impact of COVID-19, we wanted to share assure you {{ $settings->site_name }} is adhering to
            the current situation. The health and safety of our employees, customers, and communities are our
            primary concern.<br /><br /> We are taking all measures to ensure we manage to safely get through this
            fluid situation while continuing to serve our customers, partners, and employees effectively.
            <br /><br />
        </div>




        <div class="fr-view">
            <p><a class="c-call-to-action c-call-to-action--ghost title" href="https://www.bing.com/covid"
                    style="float:left;margin-right:10px; text-decoration:none; border-bottom:0.5px solid red">See
                    Covid-19 Update </a></p>
        </div>

        <br>
        <br>




    </div>
    <div class="c-media-object__col">

    </div>
</div>
</div>
</main>
@endsection
