@extends('layouts.base')

@section('title', 'Home')

@section('content')
    <!-- area-bg -->
    <div class="area__bg" data-background="assets/img/bg/area_bg.jpg">

        <!-- banner-area -->
        <section class="banner__area">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-12">
                        <div class="banner__content">
                            <span class="sub-title">
                                <svg width="8" height="16" viewBox="0 0 8 16" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                        d="M2 0H0V1V15V16H2V13.25L7.13991 8.75258C7.59524 8.35417 7.59524 7.64584 7.13991 7.24742L2 2.75V0Z"
                                        fill="currentColor" />
                                </svg>
                                Explore the world of QFS and build your decentralized Identity for the ever-expanding Web3
                                ecosystem.
                            </span>
                            <h2 class="title">The Defining <span>&nbsp;Ledger </span>for &nbsp;Web3</h2>
                            <div class="banner__btn">
                                <a href="{{ route('login') }}" class="tg-btn">
                                    <img src="assets/img/icons/btn_right_arrow.svg" alt="icon" class="right_arrow">
                                    <span>
                                        <img src="assets/img/icons/btn_icon_02.svg" alt="icon">
                                        Login
                                    </span>
                                </a>
                                <a href="{{ route('register') }}" class="tg-btn tg-btn-two">
                                    <img src="assets/img/icons/btn_right_arrow.svg" alt="icon" class="right_arrow">
                                    <span>
                                        <img src="assets/img/icons/btn_icon_03.svg" alt="icon">
                                        Get Started
                                    </span>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- banner-area-end -->

    </div>
    <!-- area-bg-end -->

    <!-- area-bg -->
    <div class="area__bg-two" data-background="assets/img/bg/area_bg_02.png">

        <!-- choose-area -->
        <section id="features" class="choose__area">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-lg-6">
                        <div class="section__title text-center mb-80">
                            <span class="sub-title">
                                <svg width="8" height="16" viewBox="0 0 8 16" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                        d="M2 0H0V1V15V16H2V13.25L7.13991 8.75258C7.59524 8.35417 7.59524 7.64584 7.13991 7.24742L2 2.75V0Z"
                                        fill="currentColor" />
                                </svg>
                                why choose us
                            </span>
                            <h2 class="title">Core features of {{ $settings->site_name }}</h2>
                        </div>
                    </div>
                </div>
                <div class="row justify-content-center gutter-y-30">
                    <div class="col-lg-4 col-md-6">
                        <div class="choose__item text-center">
                            <div class="choose__icon">
                                <img src="assets/img/icons/choose-icon01.svg" alt="icon">
                            </div>
                            <div class="choose__content">
                                <h4 class="title">Get the best possible swap rates</h4>
                                <p>From seamless transactions to intuitive interfaces, everything is designed to give you
                                    full control and confidence when managing your digital assets.</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6">
                        <div class="choose__item text-center">
                            <div class="choose__icon">
                                <img src="assets/img/icons/choose-icon02.svg" alt="icon">
                            </div>
                            <div class="choose__content">
                                <h4 class="title">Batch transactions to save on fees</h4>
                                <p>Batch multiple transactions into one to significantly reduce network fees and maximize
                                    cost efficiency without compromising speed or security.</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6">
                        <div class="choose__item text-center">
                            <div class="choose__icon">
                                <img src="assets/img/icons/choose-icon03.svg" alt="icon">
                            </div>
                            <div class="choose__content">
                                <h4 class="title">Earn swiftly, seamlessly with DeFi</h4>
                                <p>Effortlessly grow your assets by tapping into decentralized finance (DeFi) opportunities
                                    directly from our platform—no complex setups, just seamless earning.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- choose-area-end -->


        <!-- choose-area -->
        <section id="features" class="choose__area">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-lg-6">
                        <div class="section__title text-center mb-80">
                            <span class="sub-title">
                                <svg width="8" height="16" viewBox="0 0 8 16" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                        d="M2 0H0V1V15V16H2V13.25L7.13991 8.75258C7.59524 8.35417 7.59524 7.64584 7.13991 7.24742L2 2.75V0Z"
                                        fill="currentColor" />
                                </svg>
                                Smart contracts are at the core of the worldquantumleap Ledger. Their purpose? Simplify the
                                QFS experience.
                            </span>
                            <h2 class="title">The Smart Wallet Advantage</h2>
                        </div>
                    </div>
                </div>
                <div class="row justify-content-center gutter-y-30">
                    <div class="col-lg-4 col-md-6">
                        <div class="choose__item text-center">
                            <div class="choose__icon">
                                <img src="/assets/media/wallet-usp-web3.png" />
                            </div>
                            <div class="choose__content">
                                <h4 class="title">Create Your QFS Identity</h4>
                                <p>Build your on-chain persona and aggregate all your assets under one Identity.</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6">
                        <div class="choose__item text-center">
                            <div class="choose__icon">
                                <img src="/assets/media/wallet-usp-multichain.png" alt="icon">
                            </div>
                            <div class="choose__content">
                                <h4 class="title">Save on Transaction Fees</h4>
                                <p>Batch multiple transactions to execute them at once and save on gas fees.</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6">
                        <div class="choose__item text-center">
                            <div class="choose__icon">
                                <img src="/assets/media/wallet-usp-multichain.png" alt="icon">
                            </div>
                            <div class="choose__content">
                                <h4 class="title">Choose How You Pay Fees</h4>
                                <p>Cover gas fees across all supported networks with native tokens, a variety of
                                    stablecoins, or wrapped Ether (wETH).</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- choose-area-end -->

        <section class="blog__post-area section-pb-120">
            <div class="container">
                <div class="row justify-content-center gutter-50">
                    <div class="col-lg-8 col-md-12">
                        <div class="row">
                            <div class="blog__post-item shine__animate-item">
                                <div class="blog__post-thumb">
                                    <a href="#" class="shine__animate-link"><img
                                            src="/assets/media/wallet-usp-portfolio.png" alt="img"></a>
                                </div>
                                <div class="blog__post-content">
                                    <h2 class="title"><a href="#">Manage Your Portfolio</a></h2>
                                    <p>Connect multiple wallets under one single Identity to track all your digital assets
                                        from a single dashboard.</p>
                                </div>
                            </div>

                            <div class="blog__post-item shine__animate-item">
                                <div class="blog__post-thumb">
                                    <a href="#" class="shine__animate-link"><img
                                            src="/assets/media/wallet-usp-networks.png" alt="img"></a>
                                </div>
                                <div class="blog__post-content">
                                    <h2 class="title"><a href="#">Interact with 5 Networks</a></h2>
                                    <p>Send, receive, and swap crypto on Ethereum, Polygon, BNB Chain, Avalanche, and
                                        Fantom.</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-4 col-md-12">
                        <div class="blog__post-item shine__animate-item">
                            <div class="blog__post-thumb">
                                <a href="#" class="shine__animate-link"><img
                                        src="/assets/media/wallet-usp-swap.png" alt="img"></a>
                            </div>
                            <div class="blog__post-content">
                                <h2 class="title"><a href="#">Optimize Your Swaps</a></h2>
                                <p>Aggregate liquidity from multiple decentralized exchanges (DEXs) to get the best possible
                                    price. Trade assets between connected wallets to save on time and fees.</p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="load-more-btn text-center">
                    <a href="{{ route('register') }}" class="tg-btn tg-btn-two">
                        <img src="assets/img/icons/btn_right_arrow.svg" alt="icon" class="right_arrow">
                        <span>
                            <img src="assets/img/icons/btn_icon_03.svg" alt="icon">
                            Get Started
                        </span>
                    </a>
                </div>
            </div>
        </section>

    </div>
    <!-- area-bg-end -->

    <!-- roadMap-area -->
    <section id="roadmap" class="roadMap__area">
        <div class="container">
            <div class="row">
                <div class="col-lg-6">
                    <div class="roadMap__content-wrap">
                        <div class="section__title mb-50">
                            <span class="sub-title">
                                Your Identity is a unique wallet address that can be connected to one or more non-custodial
                                wallets. Here’s how to get started:
                            </span>
                            <h2 class="title">Create Your Identity & Explore QFS</h2>
                        </div>
                        <div class="roadMap__img">
                            <img src="/assets/media/wallet-how-to-visual.png" alt="img" class="alltuchtopdown">
                        </div>
                        <div class="roadMap__shape">
                            <img src="assets/img/images/roadmap_shape.png" alt="shape">
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="roadMap__item-wrap">
                        <div class="roadMap__line">
                            <span class="progress-line"></span>
                        </div>
                        <div class="roadMap__item">
                            <h4 class="title">Create a new wallet or connect an already existing non-custodial wallet.
                            </h4>
                        </div>
                        <div class="roadMap__item">
                            <h4 class="title">Activate your Identity across all supported networks.</h4>
                        </div>
                        <div class="roadMap__item">
                            <h4 class="title">Fund your Identity via a crypto transfer to start using the full suite of
                                services.</h4>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- roadMap-area-end -->

    <!-- choose-area -->
    <section id="features" class="choose__area">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-6">
                    <div class="section__title text-center mb-80">
                        <span class="sub-title">
                            Stake assets and join liquidity pools in a few clicks directly from the worldquantumleap Ledger
                            Earn tab.
                        </span>
                        <h2 class="title">Earn Passive Income with DeFi</h2>
                    </div>
                </div>
            </div>
            <div class="row justify-content-center gutter-y-30">
                <div class="col-lg-4 col-md-6">
                    <div class="choose__item text-center">
                        <div class="choose__content">
                            <h4 class="title">Make Your Wallet More Resilient</h4>
                            <p>Enable multi-sig for multiple keys and customize transaction rules to make your wallet extra
                                safe.</p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6">
                    <div class="choose__item text-center">
                        <div class="choose__content">
                            <h4 class="title">Spend with a DeFi Crypto Card</h4>
                            <p>Make everyday purchases with your crypto while keeping it in self-custody.</p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6">
                    <div class="choose__item text-center">
                        <div class="choose__content">
                            <h4 class="title">Add Funds with Card</h4>
                            <p>Enter the DeFi space seamlessly by buying crypto directly with your Visa or Mastercard.</p>
                        </div>
                    </div>
                </div>

                <div class="col-lg-4 col-md-6">
                    <div class="choose__item text-center">
                        <div class="choose__content">
                            <h4 class="title">100% Trade NFTs at Lower Cos</h4>
                            <p>Buy and sell NFTs using an aggregation from multiple marketplaces. Store them safely and
                                showcase them to the world.</p>
                        </div>
                    </div>
                </div>

                <div class="col-lg-4 col-md-6">
                    <div class="choose__item text-center">
                        <div class="choose__content">
                            <h4 class="title">Completed Token Utilities</h4>
                            <p>Enter the DeFi space seamlessly by buying crypto directly with your Visa or Mastercard.</p>
                        </div>
                    </div>
                </div>

                <div class="col-lg-4 col-md-6">
                    <div class="choose__item text-center">
                        <div class="choose__content">
                            <h4 class="title">Add Funds with Card</h4>
                            <p>Enter the DeFi space seamlessly by buying crypto directly with your Visa or Mastercard.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- choose-area-end -->


    <!-- area-bg -->
    <div class="area__bg-three" data-background="assets/img/bg/area_bg_03.jpg">

        <!-- ticker-area -->
        <div class="ticker__area">
            <div class="swiper-container ticker-active mb-30">
                <div class="swiper-wrapper slide-transition">
                    <div class="swiper-slide">
                        <div class="ticker__item">
                            <div class="ticker__item-left">
                                <img src="assets/img/icons/ticker_icon01.png" alt="img">
                                <span>StealthFi</span>
                            </div>
                            <span class="price">+$0.462</span>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="ticker__item">
                            <div class="ticker__item-left">
                                <img src="assets/img/icons/ticker_icon02.png" alt="img">
                                <span>VeilCrypto</span>
                            </div>
                            <span class="price">-$0.839</span>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="ticker__item">
                            <div class="ticker__item-left">
                                <img src="assets/img/icons/ticker_icon03.png" alt="img">
                                <span>RuneToken</span>
                            </div>
                            <span class="price">+$0.567</span>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="ticker__item">
                            <div class="ticker__item-left">
                                <img src="assets/img/icons/ticker_icon04.png" alt="img">
                                <span>MysticHash</span>
                            </div>
                            <span class="price">-$1.004</span>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="ticker__item">
                            <div class="ticker__item-left">
                                <img src="assets/img/icons/ticker_icon05.png" alt="img">
                                <span>PhantomLedger</span>
                            </div>
                            <span class="price">-$0.562</span>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="ticker__item">
                            <div class="ticker__item-left">
                                <img src="assets/img/icons/ticker_icon06.png" alt="img">
                                <span>MirageCoin</span>
                            </div>
                            <span class="price">+$1.493</span>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="ticker__item">
                            <div class="ticker__item-left">
                                <img src="assets/img/icons/ticker_icon07.png" alt="img">
                                <span>MirageCoin</span>
                            </div>
                            <span class="price">+$1.493</span>
                        </div>
                    </div>
                </div>
            </div>
            <div dir="rtl" class="swiper-container ticker-active">
                <div class="swiper-wrapper slide-transition">
                    <div class="swiper-slide">
                        <div class="ticker__item">
                            <div class="ticker__item-left">
                                <img src="assets/img/icons/ticker_icon08.png" alt="img">
                                <span>StealthFi</span>
                            </div>
                            <span class="price">+$0.462</span>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="ticker__item">
                            <div class="ticker__item-left">
                                <img src="assets/img/icons/ticker_icon03.png" alt="img">
                                <span>VeilCrypto</span>
                            </div>
                            <span class="price">-$0.839</span>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="ticker__item">
                            <div class="ticker__item-left">
                                <img src="assets/img/icons/ticker_icon09.png" alt="img">
                                <span>RuneToken</span>
                            </div>
                            <span class="price">+$0.567</span>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="ticker__item">
                            <div class="ticker__item-left">
                                <img src="assets/img/icons/ticker_icon04.png" alt="img">
                                <span>MysticHash</span>
                            </div>
                            <span class="price">-$1.004</span>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="ticker__item">
                            <div class="ticker__item-left">
                                <img src="assets/img/icons/ticker_icon06.png" alt="img">
                                <span>PhantomLedger</span>
                            </div>
                            <span class="price">-$0.562</span>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="ticker__item">
                            <div class="ticker__item-left">
                                <img src="assets/img/icons/ticker_icon01.png" alt="img">
                                <span>MirageCoin</span>
                            </div>
                            <span class="price">+$1.493</span>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="ticker__item">
                            <div class="ticker__item-left">
                                <img src="assets/img/icons/ticker_icon03.png" alt="img">
                                <span>MirageCoin</span>
                            </div>
                            <span class="price">+$1.493</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- ticker-area-end -->

        <!-- section-divider -->
        <div class="section-divider">
            <div class="container">
                <span></span>
            </div>
        </div>
        <!-- section-divider -->

        <!-- summary-area -->
        <section class="summary__area section-py-120">
            <div id="particles-js"></div>
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-6">
                        <div class="summary__img">
                            <img src="https://worldquantumleap.com/home/content.nexo.com/media/wallet-hacken-visual.png"
                                alt="img">
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="summary__content">
                            <div class="section__title mb-50">
                                <h2 class="title">Continuously Audited</h2>
                            </div>
                            <div class="progress__wrap">
                                <div class="progress__item">
                                    <div class="progress__item-top">
                                        <h3 class="progress__title">
                                            The worldquantumleap Ledger’s smart contracts passed the Hacken audit with a
                                            10/10 score to meet the highest blockchain security standards.
                                        </h3>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- summary-area-end -->

    </div>
    <!-- area-bg-end -->

    <!-- faq-area -->
    <section id="faq" class="faq__area section-py-120">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="faq__wrap">
                        <div class="accordion" id="accordionExample">
                            <div class="accordion-item">
                                <h2 class="accordion-header">
                                    <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                        data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                                        What is decentralized identity?
                                    </button>
                                </h2>
                                <div id="collapseOne" class="accordion-collapse collapse show"
                                    data-bs-parent="#accordionExample">
                                    <div class="accordion-body">
                                        <p>Decentralized Identity is a type of identity management that allows the control
                                            of personal information existing online without the involvement of third parties
                                            (social media, email service providers, etc.).

                                            With the current version of the worldquantumleap Ledger, you can create your own
                                            decentralized Identity. We will pair it with an existing or newly created wallet
                                            address, and you will be able to use the wallet to sign transactions.

                                            Additionally, the worldquantumleap Ledger allows you to pair your Identity with
                                            an external, non-custodial wallet, such as Metamask. This will help you
                                            aggregate all your assets in a single dashboard and under one Identity.</p>
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <h2 class="accordion-header">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                        data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                                        How are smart wallets different from standard wallets?
                                    </button>
                                </h2>
                                <div id="collapseTwo" class="accordion-collapse collapse"
                                    data-bs-parent="#accordionExample">
                                    <div class="accordion-body">
                                        <p>Non-custodial wallets serve as the main entry point for users opting to
                                            self-custody their assets and interact with blockchain applications. They can be
                                            accessed only through a seed phrase – a cluster of words, generated randomly by
                                            your wallet, proving the ownership of funds stored in the wallet. With a
                                            non-custodial wallet, you can execute transactions on DEXs, trade NFTs, swap
                                            tokens, earn interest, and more.

                                            Smart wallets are non-custodial wallets controlled through smart contracts that
                                            allow for an ​​ecosystem of asset management features to be built on top. Among
                                            the most popular features are transaction batching, wallet aggregation, and
                                            paying gas fees with non-native tokens, all of which can be found on the
                                            worldquantumleap Ledger.</p>
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <h2 class="accordion-header">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                        data-bs-target="#collapseThree" aria-expanded="false"
                                        aria-controls="collapseThree">
                                        
								How do I fund my worldquantumleap Ledger? 							
                                    </button>
                                </h2>
                                <div id="collapseThree" class="accordion-collapse collapse"
                                    data-bs-parent="#accordionExample">
                                    <div class="accordion-body">
                                        <p>You can add funds to your worldquantumleap Ledger before you have created your decentralized Identity. When you click on the “Receive Assets” button in the upper right corner of their dashboard, a unique Identity address will be displayed on the screen to be copied and pasted on the respective sender platform. Once done, you can transfer funds to your worldquantumleap Ledger via one of the five supported chains.</p>
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <h2 class="accordion-header">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                        data-bs-target="#collapseFour" aria-expanded="false"
                                        aria-controls="collapseFour">
                                        
								Which transaction chains are supported on the worldquantumleap Ledger?							
                                    </button>
                                </h2>
                                <div id="collapseFour" class="accordion-collapse collapse"
                                    data-bs-parent="#accordionExample">
                                    <div class="accordion-body">
                                        <p>The worldquantumleap Ledger supports five networks – Ethereum, Polygon, BNB Chain, Avalanche, and Fantom. Each of them requires a separate Identity, which can be created with a click of a button. You can manage your existing digital Identities from the section in the top right corner of the dashboard.</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- faq-area-end -->

    <!-- contact-area -->
    <section id="contact" class="contact__area">
        <div class="container">
            <div class="contact__inner-wrap">
                <div class="row justify-content-center">
                    <div class="col-lg-8">
                        <div class="section__title text-center mb-50">
                            <span class="sub-title white-title">
                                <svg width="8" height="16" viewBox="0 0 8 16" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                        d="M2 0H0V1V15V16H2V13.25L7.13991 8.75258C7.59524 8.35417 7.59524 7.64584 7.13991 7.24742L2 2.75V0Z"
                                        fill="currentColor" />
                                </svg>
                                get in touch
                            </span>
                            <h2 class="title">Ask anything from anywhere!</h2>
                        </div>
                    </div>
                    <div class="col-xl-6 col-lg-8">
                        <form action="https://themeadapt.com/tf/ironik/assets/mail.php" class="contact__form"
                            method="POST" id="contact-form">
                            <div class="row">
                                <div class="col-lg-6">
                                    <div class="form-grp">
                                        <label for="name">Full name</label>
                                        <input id="name" name="name" type="text" placeholder="E.g. Jhon">
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-grp">
                                        <label for="email">Email address</label>
                                        <input id="email" name="email" type="email" placeholder="E.g. Jhon">
                                    </div>
                                </div>
                            </div>
                            <div class="form-grp">
                                <label for="message">Message</label>
                                <textarea name="message" id="message" placeholder="Let us know"></textarea>
                            </div>
                            <div class="submit__btn text-center">
                                <button type="submit" class="tg-btn tg-btn-two">
                                    <img src="assets/img/icons/btn_right_arrow.svg" alt="icon" class="right_arrow">
                                    <span>
                                        <img src="assets/img/icons/btn_icon_03.svg" alt="">
                                        submit now
                                    </span>
                                </button>
                            </div>
                        </form>
                        <p class="ajax-response mb-0 text-center"></p>
                    </div>
                </div>
                <div class="contact__shape-wrap">
                    <img src="assets/img/images/contact_shape01.png" alt="img" class="alltuchtopdown">
                    <img src="assets/img/images/contact_shape02.png" alt="img">
                </div>
            </div>
        </div>
    </section>
    <!-- contact-area-end -->
@endsection
