@props(['name', 'oldValue' => false])

@error($name)
    <select name="{{ $name }}" {{ $attributes->merge(['class' => 'is-invalid']) }}>
        @if ($oldValue && old($name))
            <option value="{{ old($name) }}">{{ ucfirst(old($name)) }}</option>
        @endif
        {{ $slot }}
    </select>
@else
    <select name="{{ $name }}" {{ $attributes }}>
        @if ($oldValue && old($name))
            <option>{{ old($name) }}</option>
        @endif
        {{ $slot }}
    </select>
@enderror

@error($name)
    <div class="invalid-feedback d-block">
        {{ $message }}
    </div>
@enderror
