@extends('layouts.base')

@section('title', 'Create an Account')

@section('content')
    <section class="breadcrumb__area">
        <div class="breadcrumb__bg" data-background="assets/img/bg/breadcrumb_bg.png"
            style="background-image: url(&quot;assets/img/bg/breadcrumb_bg.png&quot;);"></div>
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="breadcrumb__content">
                        <span class="sub-title">
                            <svg width="8" height="16" viewBox="0 0 8 16" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd"
                                    d="M2 0H0V1V15V16H2V13.25L7.13991 8.75258C7.59524 8.35417 7.59524 7.64584 7.13991 7.24742L2 2.75V0Z"
                                    fill="currentColor"></path>
                            </svg>
                            Account
                        </span>
                        <h1 class="title">Get Started</h1>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section id="contact" class="contact__area">
        <div class="container">
            <div class="contact__inner-wrap">
                <div class="row justify-content-center">
                    @if (Session::has('status'))
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            {{ session('status') }}
                        </div>
                    @endif
                    <div class="col-xl-6 col-lg-8">
                        <form action="{{ route('register') }}" class="contact__form" method="POST">
                            @csrf
                            <div class="row">
                                <div class="col-lg-6">
                                    <div class="form-grp">
                                        <label for="name">Full name</label>
                                        <x-form.input name="name" placeholder="Full Name" required=""
                                            value="{{ old('name') }}" />
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-grp">
                                        <label for="email">Email address</label>
                                        <x-form.input name="email" placeholder="john@doe.com" required=""
                                            value="{{ old('email') }}" />
                                    </div>
                                </div>

                                <div class="col-lg-6">
                                    <div class="form-grp">
                                        <label for="email">Username</label>
                                        <x-form.input style="background-size: 12px, 1px;" name="username"
                                            class="_5-text-field name w-input" placeholder="Username" required=""
                                            value="{{ old('username') }}" />
                                    </div>
                                </div>

                                <div class="col-lg-6">
                                    <div class="form-grp">
                                        <label for="email">Phone</label>
                                        <x-form.input style="background-size: 12px, 1px;" name="phone"
                                            class="_5-text-field phone w-input" placeholder="Phone Number" required=""
                                            value="{{ old('phone') }}" />
                                    </div>
                                </div>


                                <div class="col-lg-6">
                                    <div class="form-grp">
                                        <label for="email">Password</label>
                                        <x-form.input type="password" style="background-size: 12px, 1px;" name="password"
                                            class="_5-text-field password w-input" placeholder="Password" required="" />
                                    </div>
                                </div>

                                <div class="col-lg-6">
                                    <div class="form-grp">
                                        <label for="email">Retype Password</label>
                                        <x-form.input type="password" style="background-size: 12px, 1px;"
                                            name="password_confirmation" class="_5-text-field password w-input"
                                            placeholder="Retype Password" required="" />
                                    </div>
                                </div>

                                <div class="col-lg-12">
                                    <div class="form-grp">
                                        <label for="email">Country</label>
                                        <select name="country" id="country" required>
                                            <option value="">Choose Country</option>
                                            @include('auth.countries')
                                        </select>

                                        @error('country')
                                            <div class="text-danger">{{ $message }}</div>
                                            @endif
                                        </div>
                                    </div>
                                </div>

                                @if (Session::has('ref_by'))
                                    <div class="col-lg-12">
                                        <div class="form-grp">
                                            <label>Referral ID</label>
                                            <x-form.input style="background-size: 12px, 1px;" name="email"
                                                class="_5-text-field name w-input" placeholder="Referral ID" required=""
                                                value="{{ session('ref_by') }}" name="ref_by" />
                                        </div>
                                    </div>
                                @else
                                    <div class="col-lg-12">
                                        <div class="form-grp">
                                            <label>Referral ID</label>
                                            <x-form.input style="background-size: 12px, 1px;" name="email"
                                                class="_5-text-field name w-input" placeholder="Referral ID" name="ref_by"
                                                placeholder="Optional Referral ID" />
                                        </div>
                                    </div>
                                @endif

                                @if ($settings->captcha == 'true')
                                    <div class="col-lg-6">
                                        <div class="form-grp {{ $errors->has('g-recaptcha-response') ? ' has-error' : '' }}">
                                            <label>Captcha<span class="text-danger">*</span></label>
                                            <div class="position-relative">
                                                {!! NoCaptcha::display() !!}
                                                @if ($errors->has('g-recaptcha-response'))
                                                    <span class="help-block">
                                                        <strong>{{ $errors->first('g-recaptcha-response') }}</strong>
                                                    </span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                @endif
                                @if ($settings->enable_social_login == 'yes')
                                    <div class="col-lg-6">
                                        <div class="form-grp" style="text-align: center">
                                            <label>Or</label>
                                            <div class="col-12 my-3">
                                                <a href="{{ route('social.redirect', ['social' => 'google']) }}"
                                                    class="login-with-google-btn">
                                                    <i class="mdi mdi-google text-danger"></i> Sign in with
                                                    Google</a>
                                            </div>
                                        </div>
                                    </div>
                                @endif
                        </div>
                        <div class="submit__btn text-center">
                            <button type="submit" class="tg-btn tg-btn-two">
                                <img src="assets/img/icons/btn_right_arrow.svg" alt="icon" class="right_arrow">
                                <span>
                                    <img src="assets/img/icons/btn_icon_03.svg" alt="">
                                    submit now
                                </span>
                            </button>
                        </div>
                        </form>
                        <p class="ajax-response mb-0 text-center"></p>
                    </div>
                </div>
                <div class="contact__shape-wrap">
                    <img src="assets/img/images/contact_shape01.png" alt="img" class="alltuchtopdown">
                    <img src="assets/img/images/contact_shape02.png" alt="img">
                </div>
            </div>
        </div>
    </section>
    @endsection
