@extends('layouts.app')
@section('content')
<div class="mt-2 mb-4">
    <h1 class="title1 ">Inbox Details</h1>
</div>

<div class="mb-5 row">
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                @if (session('success'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    {{ session('success') }}
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                @endif
                <form method="post">
                    @csrf
                    <div class="row">
                        <div class="form-group col-md-6">
                            <h5 class="">User</h5>
                            <input class="form-control" value="{{ $inbox->user->name }}" disabled>
                        </div>

                        <div class="form-group col-md-6">
                            <h5 class="">Reference</h5>
                            <input class="form-control" value="{{ $inbox->ref }}" disabled>
                        </div>

                        <div class="form-group col-md-6">
                            <h5 class="">Subject</h5>
                            <x-form.input name="subject" class="form-control" value="{{ $inbox->subject }}" />
                        </div>

                        <div class="form-group col-md-6">
                            <h5 class="">Date</h5>
                            <x-form.input name="date" class="form-control" value="{{ $inbox->date->format('Y-m-d') }}"
                                type="date" />
                        </div>

                        <div class="form-group col-md-12">
                            <h5 class="">Status</h5>
                            <x-form.select name="status" class="form-control">
                                <option value="{{ $inbox->status }}" selected> {{ $inbox->status }} </option>
                                <option value="open">open</option>
                                <option value="closed">closed</option>
                            </x-form.select>
                        </div>

                        <div class="form-group col-md-12">
                            <button class="btn btn-primary w-100">Submit</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection