@extends('layouts.app')
@section('content')
    <div class="d-flex justify-content-between align-items-center">
        <div>
            <h1 class="title1 ">Update Plan</h1>
        </div>
        <div>
            <a href="{{ route('plans') }}" class="btn btn-sm btn-primary"> <i class="fa fa-arrow-left"></i>
                Back</a>
        </div>
    </div>
    <x-admin.alert />
    <div class="mb-5 row">
        <div class="col-lg-12 ">
            <div class="p-3 card ">
                <form role="form" method="post" action="{{ route('updateplan') }}">
                    <div class="form-row">
                        <div class="form-group col-md-6">
                            <h5 class="">Plan Name</h5>
                            <input class="form-control  " value="{{ $plan->name }}" placeholder="Enter Plan name"
                                type="text" name="name" required>
                        </div>
                        <div class="form-group col-md-6">
                            <h5 class="">Plan price({{ $settings->currency }})</h5>
                            <input class="form-control  " value="{{ $plan->price }}" placeholder="Enter Plan price"
                                type="number" name="price" required>
                            <small class="">This is the maximum amount a user can pay
                                to invest in this plan</small>
                        </div>
                        <div class="form-group col-md-6">
                            <h5 class="">Plan Minimum Price
                                ({{ $settings->currency }})</h5>
                            <input placeholder="Enter Plan minimum price" value="{{ $plan->min_price }}"
                                class="form-control  " type="number" step="any" name="min_price" required>
                            <small class="">This is the minimum amount a user can pay
                                to invest in this plan</small>
                        </div>
                        <div class="form-group col-md-6">
                            <h5 class="">Plan Maximum Price
                                ({{ $settings->currency }})</h5>
                            <input class="form-control  " value="{{ $plan->max_price }}"
                                placeholder="Enter Plan maximum price" type="number" step="any" name="max_price"
                                required>
                            <small class="">Same as plan price</small>
                        </div>
                        <div class="form-group col-md-6">
                            <h5 class="">Minimum return (%)</h5>
                            <input class="form-control  " value="{{ $plan->minr }}" placeholder="Enter minimum return"
                                type="number" step="any" name="minr" required>
                            <small class="">This is the minimum return (ROI) for this
                                plan</small>
                        </div>
                        <div class="form-group col-md-6">
                            <h5 class="">Maximum return (%)</h5>
                            <input class="form-control  " value="{{ $plan->maxr }}" placeholder="Enter maximum return"
                                type="number" step="any" name="maxr" required>
                            <small class="">This is the Maximum return (ROI) for this
                                plan</small>
                        </div>
                        <div class="form-group col-md-6">
                            <h5 class="">Gift Bonus ({{ $settings->currency }})</h5>
                            <input class="form-control  " value="{{ $plan->gift }}"
                                placeholder="Enter Additional Gift Bonus" type="number" step="any" name="gift"
                                value="0" required>
                            <small class="">Optional Bonus if a user buys this plan.
                            </small>
                        </div>
                        <div class="form-group col-md-6">
                            <h5 class="">Top up Interval</h5>
                            <select class="form-control  " name="t_interval">
                                <option>{{ $plan->increment_interval }}</option>
                                <option>Monthly</option>
                                <option>Weekly</option>
                                <option>Daily</option>
                                <option>Hourly</option>
                                <option>Every 30 Minutes</option>
                                <option>Every 10 Minutes</option>
                            </select>
                            <small class="">This specifies how often the system should
                                add profit(ROI) to user account.</small>
                        </div>
                        <div class="form-group col-md-6">
                            <h5 class="">Top up Type</h5>
                            <select class="form-control  " name="t_type">
                                <option>{{ $plan->increment_type }}</option>
                                <option>Percentage</option>
                                <option>Fixed</option>
                            </select>
                            <small class="">This specifies if the system should add
                                profit in percentage(%) or a fixed amount.</small>
                        </div>
                        <div class="form-group col-md-6">
                            <h5 class="">Top up Amount (in % or
                                {{ $settings->currency }} as specified above)</h5>
                            <input class="form-control  " value="{{ $plan->increment_amount }}" placeholder="top up amount"
                                type="number" step="any" name="t_amount" required>
                            <small class="">This is the amount the system will add to
                                users account as profit, based on what you selected in topup type and topup
                                interval above. </small>
                        </div>

                        <div class="form-group col-md-12">
                            <h5 class="">Description</h5>
                            <x-form.textarea name="description" value="{{ $plan->description }}" class="form-control" rows="5" />
                            <small class="">This description will show in user dashboard to tell the users of the kind of plan they are investing in.</small>
                        </div>
                        <div class="form-group col-md-6">
                            <h5 class="">Investment Duration</h5>
                            <input class="form-control  "value="{{ $plan->expiration }}"
                                placeholder="eg 1 Days, 2 Weeks, 1 Months" type="text" name="expiration" required>
                            <small class="">This specifies how long the investment plan
                                will run. Please strictly follow the guide on <a href="" data-toggle="modal"
                                    data-target="#durationModal">how to setup investment
                                    duration</a> else it may not work. </small>

                        </div>
                        <div class="form-group col-md-12">
                            <input type="hidden" name="id" value="{{ $plan->id }}">
                            <input type="hidden" name="_token" value="{{ csrf_token() }}">
                            <input type="submit" class="btn btn-primary" value="Update Plan">
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div id="durationModal" class="modal fade" role="dialog">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-body ">
                    <h5 class="">FIRSTLY, Always preceed the time frame with a digit, that is
                        do not write the number in letters, <br> <br> SECONDLY, always add space after the number, <br>
                        <br> LASTLY, the first letter of the timeframe should be in CAPS and always add 's' to the
                        timeframe even if your duration is just a day, month or year.
                    </h5>
                    <h2 class="">Eg, 1 Days, 3 Weeks, 1 Hours, 48 Hours, 4 Months, 1 Years, 9
                        Months</h2>

                </div>
            </div>
        </div>
    </div>
@endsection
