// Set the date we're counting down to
var countDownDate = new Date("Jan 1, 2023 00:00:00").getTime();
// Update the count down every 1 second
var x = setInterval(function() {
    // Get today's date and time
    var now = new Date().getTime();
    // Find the distance between now and the count down date
    var distance = countDownDate - now;
    // Time calculations for days, hours, minutes and seconds
    var days = Math.floor(distance / (1000 * 60 * 60 * 24));
    var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
    var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
    var seconds = Math.floor((distance % (1000 * 60)) / 1000);
    // Output the result in an element with id="demo"
    $('#countdown').html(days + "D " + hours + "H " + minutes + "M " + seconds + "S ");
    // If the count down is over, write some text 
    if (distance < 0) {
        clearInterval(x);
        $('#countdown').html("Listed");
    }
}, 1000);


// Countdown Clock
var $count_token_clock = $('.token-countdown-clock');
if ($count_token_clock.length > 0) {
    $count_token_clock.each(function() {
        var $self = $(this),
            datetime = $self.attr("data-date");
        $self.countdown(datetime).on('update.countdown', function(event) {
            $(this).html(event.strftime('' + '<div class="col"><span class="countdown-time countdown-time-first">%D</span><span class="countdown-text">Days</span></div>' + '<div class="col"><span class="countdown-time">%H</span><span class="countdown-text">Hours</span></div>' + '<div class="col"><span class="countdown-time countdown-time-last">%M</span><span class="countdown-text">Minutes</span></div>'));
        });
    });
}


function validateInt(int) {
    result = int.match(/[^0-9]/g);
    if (result) {
        return false;
    } else {
        return true;
    }
}

$('#withdraw').on('click', function() {
    Notiflix.Report.Info('Awaiting listing', 'You will recieve an email when we are officially listed in exchanges and wallets', 'Okay, I understand');
});

$('#scoEqu').on('keyup', function() {
    var scoquantity = $.trim($(this).val());
    var conv = $.trim($('#conv-equ').val());
    if (validateInt(scoquantity)) {
        $('#usdEqu-buy').val(scoquantity * conv);
    } else {
        $('#usdEqu').val('');
    }
});

$('#usdEqu-buy').on('keyup', function() {
    var usdEqu = $.trim($(this).val());
    var conv = $.trim($('#conv-equ').val());
    if (validateInt(usdEqu)) {
        $('#scoEqu').val(usdEqu / conv);
    } else {
        $('#scoEqu').val('');
    }
});

$('#buySco').on('click', function() {
    var usdEqu = $.trim($('#usdEqu-buy').val());
    var scoquantity = $.trim($('#scoEqu').val());
    if (usdEqu != '' && scoquantity != '') {
        if (confirm('Do you want to purchase $' + usdEqu + ' worth of Swisscoin (SCO)?')) {
            $.ajax({
                type: "POST",
                url: "./backend/__ico.php",
                data: {
                    ico: scoquantity
                },
                dataType: "text",
                beforeSend: function() {
                    Notiflix.Block.Hourglass('.modal.fade.show', 'Purchasing SCO !!');
                },
                success: function(response) {
                    Notiflix.Block.Remove('.modal.fade.show');
                    response = jQuery.parseJSON(response);
                    switch (response) {
                        case 1:
                            Notiflix.Notify.Success('SCO token purchased successfully!, Please refresh')
                            break;
                        case 0:
                            Notiflix.Notify.Failure('Error purchasing token, try again later')
                            break;
                        case -1:
                            Notiflix.Notify.Warning('Not enough funds from source to buy token, Check balance')
                            break;
                        case -2:
                            Notiflix.Notify.Warning('Please enter a valid amount !!')
                            break;
                        default:
                            Notiflix.Notify.Failure('Error, Try again later !!')
                            break;
                    }
                }
            });
        }
    }
});