<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDepositsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('deposits', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('txn_id')->nullable();
            $table->foreignId('wdmethod_id')->constrained()->onDelete('cascade');
            $table->integer('user')->nullable();
            $table->string('amount')->nullable();
            $table->string('payment_mode')->nullable();
            $table->integer('plan')->nullable();
            $table->string('status')->nullable();
            $table->string('proof')->nullable();
            $table->string('hash')->unique();
            $table->timestamp('date_received')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('deposits');
    }
}
