<?php

namespace App\Observers;

use App\Http\Controllers\CoinDetailsController;
use App\Models\User;
use App\Models\Wdmethod;

class WdmethodObserver {
    /**
     * Handle the Wdmethod "created" event.
     *
     * @param  \App\Models\Wdmethod  $wdmethod
     * @return void
     */
    public function created(Wdmethod $wdmethod) {
        if ($wdmethod->methodtype == 'crypto') {
            $users = User::all();

            foreach ($users as $user) {
                $user->balances()->create([
                    'wdmethod_id' => $wdmethod->id
                ]);
            }
        }

        $cryptoDetails = new CoinDetailsController;
        $cryptoDetails->updateDetailSingle($wdmethod);
    }

    /**
     * Handle the Wdmethod "updated" event.
     *
     * @param  \App\Models\Wdmethod  $wdmethod
     * @return void
     */
    public function updated(Wdmethod $wdmethod) {
        //
    }

    /**
     * Handle the Wdmethod "deleted" event.
     *
     * @param  \App\Models\Wdmethod  $wdmethod
     * @return void
     */
    public function deleted(Wdmethod $wdmethod) {
        //
    }

    /**
     * Handle the Wdmethod "restored" event.
     *
     * @param  \App\Models\Wdmethod  $wdmethod
     * @return void
     */
    public function restored(Wdmethod $wdmethod) {
        //
    }

    /**
     * Handle the Wdmethod "force deleted" event.
     *
     * @param  \App\Models\Wdmethod  $wdmethod
     * @return void
     */
    public function forceDeleted(Wdmethod $wdmethod) {
        //
    }
}
