<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CryptoBalance extends Model
{
    protected $guarded = ['id'];
    
    use HasFactory;

    public function user() {
        return $this->belongsTo(User::class);
    }

    public function wdmethod() {
        return $this->belongsTo(Wdmethod::class);
    }

    public function getFiatValueAttribute() {
        return $this->value * $this->wdmethod->details->PRICE;
    }
}
