<?php

namespace App\Mail\Admin;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\File;

class CardRequest extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(public $request) {}

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $receiptPath = $this->request['payment_receipt'];
        $receiptMime = pathinfo($receiptPath, PATHINFO_EXTENSION);

        return $this->view('emails.admin.card-request')
            ->attach($this->request['payment_receipt'], [
                'as' => "Payment Receipt.$receiptMime",
                'mime' => File::mimeType($receiptPath),
            ]);
    }
}
