<?php

namespace App\Http\Livewire\Admin\Inbox;

use App\Models\Inbox;
use Livewire\Component;

class Manage extends Component 
{
    
    public $search = '';
    public $status;
    public $per_page = 10;
    public $order = 'desc';
    public $from_date = '';
    public $to_date = '';

    public function render() {
        return view('livewire.admin.inbox.manage', [
            'inboxes' => Inbox::search($this->search)
                ->when($this->status, function ($query) {
                    return $query->where('status', $this->status);
                })
                ->orderBy('id', $this->order)
                ->ofDate($this->from_date, $this->to_date)
                ->paginate($this->per_page),

            'shorten' => fn($text) => $this->shorten($text),
        ]);
    }

    public function shorten($text, $maxWords = 10) {
        $words = explode(' ', $text);
        if (count($words) > $maxWords) {
            return implode(' ', array_slice($words, 0, $maxWords)) . '...';
        }
        return $text;
    }

    public function resetFilters() {
        $this->reset('search', 'status', 'per_page', 'order', 'from_date', 'to_date');
    }

    public function deleteInbox(Inbox $inbox) {
        $inbox->delete();
        session()->flash('success', 'Inbox deleted successfully.');
    }
}
