<?php

namespace App\Http\Livewire\Admin\Inbox;

use App\Models\Inbox;
use Livewire\Component;

class Conversations extends Component
{
    public Inbox $inbox;
    public $message;

    protected $listeners = ['messageSent' => '$refresh'];

    public function render() {
        return view('livewire.admin.inbox.conversations', [
            'conversations' => $this->inbox->conversations
        ]);
    }

    protected $rules = [
        'message' => 'required|max:255',
    ];

    public function sendMessage() {
        $this->validate();
        if($this->inbox->status == 'closed') {
            $this->inbox->update([
                'status' => 'open'
            ]);
        }

        $this->inbox->conversations()->create([
            'sender' => 'admin',
            'content' => $this->message,
        ]);
        $this->reset('message');
        $this->inbox->user->notify("You have a new reply on conversation {$this->inbox->ref}.");
        $this->emit('messageSent');
    }
}
