<?php

namespace App\Http\Livewire\Admin\Deposit;

use App\Mail\DepositStatus;
use App\Models\Deposit;
use App\Models\Settings;
use App\Models\Tp_Transaction;
use App\Models\User;
use App\Notifications\AccountNotification;
use App\Services\ReferralCommisionService;
use App\Traits\PingServer;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Storage;
use Livewire\Component;
use Livewire\WithPagination;

class ManageDeposit extends Component {
    use WithPagination;
    use PingServer;

    protected $paginationTheme = 'bootstrap';
    public $search = '';
    public $order = 'desc';
    public $status = 'All';
    public $perPage = 10;
    public $toDate = '';
    public $fromDate = '';
    public $deleteId = '';

    protected $queryString = [
        'search' => ['except' => ''],
    ];


    public function render() {
        return view('livewire.admin.deposit.manage-deposit', [
            'deposits' => Deposit::ofSearch($this->search)->ofStatus($this->status)->orderBy('id', $this->order)->with('duser:id,name')->ofDate($this->fromDate, $this->toDate)->paginate($this->perPage),
        ]);
    }


    //reset all filter
    public function resetFilter() {
        $this->reset(['search', 'order', 'status', 'perPage', 'toDate', 'fromDate']);
    }

    public function deleteId($id) {
        $this->deleteId = $id;
    }

    // delete deposit record 
    public function delete() {
        $deposit = Deposit::findOrFail($this->deleteId);
        try {
            if (!empty($deposit->proof) && Storage::disk('public')->exists($deposit->proof)) {
                Storage::disk('public')->delete($deposit->proof);
            }
            $deposit->delete();
            session()->flash('success', 'Deposit deleted successfully!');
        } catch (\Throwable $th) {
            session()->flash('error', 'Something went wrong!, deposit does not exist.');
        }
    }
}
