<?php

namespace App\Http\Controllers\User;

use App\Models\User;
use App\Models\Withdrawal;
use App\Models\Settings;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\CryptoBalance;
use App\Models\Wdmethod;

class WithdrawalAccountsController extends Controller
{
    public function index() {
        $user = User::with('balances')->find(auth()->id());
        $settings = Settings::where('id', 1)->first();

        return view("{$settings->theme}.user.withdrawal-accounts", [
            'title' => 'Withdrawal Accounts',
            'user' => $user,
            'withdrawals' => Withdrawal::where('user', $user->id)->get(),
            'id' => 1,
        ]);
    }

    public function add(Request $request) {
        $request->validate([
            'address' => 'required|string|min:26',
            'account' => 'required',
            'amount' => 'required|numeric'
        ]);

        $method = Wdmethod::find($request->account);
        $user = User::find(auth()->id());

        $balance = $user->balances()->where('wdmethod_id', $method->id)->first();
        if($balance->value < $request->amount) {
            return back()->with('error', 'Amount is greater than account balance.')->withInput();
        }
        Withdrawal::create([
            'user' => $user->id,
            'amount' => $request->amount,
            'to_deduct' => $request->amount,
            'payment_mode' => $method->symbol,
            'paydetails' => $request->address,
            'status' => 'Pending',
        ]);
        return back()->with('success', 'Withdrawal request sent successfully.');
    }

    public function delete(Withdrawal $withdrawal) {
        $withdrawal->delete();

        return back()->with('success', 'Withdrawal Request successfully deleted.');
    }
}
