<?php

namespace App\Http\Controllers\User;

use App\Models\User;
use App\Models\Settings;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class VerificationController extends Controller
{
    public function index() {
        $settings = Settings::where('id', 1)->first();
        
        return view("{$settings->theme}.user.verification", [
            'title' => 'User Verification',
            'user' => auth()->user(),
        ]);
    }

    public function submit(Request $request) {
        $kycDetails = $request->validate([
            'id_type' => 'required|string',
            'id_card' => 'required|mimes:jpg,png,jpeg,pdf|max:4096',
        ]);

        $user = User::find(auth()->id());
        
        if($request->hasFile('id_card')) {
            $kycDetails['id_card'] = '/uploads/'. $request->file('id_card')->store('kyc_images', 'uploads');
        }

        $kycDetails['status'] = 'Under review';
        
        if(!$user->kyc) {
            $user->kyc()->create($kycDetails);
            $user->update([
                'account_verify' => 'Verified'
            ]);
        }

        return back()->with('success', 'KYC details received. You will be notified soon.');
    }
}
