<?php

namespace App\Http\Controllers\User;

use App\Models\User;
use App\Models\Settings;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Wdmethod;

class SwapController extends Controller {
    public function index() {
        $settings = Settings::where('id', 1)->first();
        return view("{$settings->theme}.user.swap", [
            'title' => 'Balance Swapping',
            'user' => User::with('balances')->find(auth()->id()),
        ]);
    }

    public function swap(Request $request) {
        $request->validate([
            'from' => 'required',
            'to' => 'required',
            'amount' => 'required|numeric'
        ]);

        if ($request->from == $request->to) {
            return back()
                ->with('error', 'Double balance selected: destination balance cannot be same as sending account.')
                ->withInput($request->only('amount'));
        }
        $user = User::find(auth()->id());

        $fromMethod = Wdmethod::where('symbol', $request->from)->first();
        $fromAmountInCrypto =  $this->amountInCoin($request->amount, $fromMethod);
        $fromUserBalance = $user->balances()->where('wdmethod_id', $fromMethod->id)->first();

        if ($fromAmountInCrypto > $fromUserBalance->value) {
            return back()
                ->with('error', 'Insufficient Balance.')
                ->withInput($request->only(['from', 'to']));
        }

        $toMethod = Wdmethod::where('symbol', $request->to)->first();
        $toAmountInCrypto = $this->amountInCoin($request->amount, $toMethod);
        $toUserBalance = $user->balances()->where('wdmethod_id', $toMethod->id)->first();
        
        $toUserBalance->update([
            'value' => $toUserBalance->value + $toAmountInCrypto,
        ]);

        $fromUserBalance->update([
            'value' => $fromUserBalance->value - $fromAmountInCrypto
        ]);
        

        return redirect(route('accounts'))->with('success', 'Swap Completed Successfully.');
    }
}
