<?php

namespace App\Http\Controllers\User;

use App\Models\User;
use App\Models\Settings;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Notification;

class NotificationController extends Controller
{
    public function index() {
        $settings = Settings::where('id', 1)->first();
        $user = User::find(auth()->id());

        return view("{$settings->theme}.user.notifications", [
            'title' => 'Notifications',
            'user' => $user,
            'id' => 1,
        ]);
    }

    public function read(Notification $notification) {
        $notification->update([
            'read_at' => now(),
        ]);

        return back()->with('success', 'Notification marked as read.');
    }
}
