<?php

namespace App\Http\Controllers\User;

use App\Models\User;
use App\Models\Plans;
use App\Models\Settings;
use App\Models\Wdmethod;
use App\Models\User_plans;
use Illuminate\Http\Request;
use App\Mail\NewNotification;
use App\Models\Tp_Transaction;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Mail;
use App\Notifications\AccountNotification;

class InvestmentController extends Controller {
    public function index() {
        $settings = Settings::where('id', 1)->first();

        return view("{$settings->theme}.user.invest.all", [
            'title' => 'New Investment',
            'plans' => Plans::active()->get(),
            'user' => User::find(auth()->id()),
        ]);
    }

    public function start(Plans $plan) {
        $settings = Settings::where('id', 1)->first();

        return view("{$settings->theme}.user.invest.single", [
            'title' => 'New Investment',
            'plan' => $plan,
            'user' => User::find(auth()->id()),
        ]);
    }

    public function invest(Plans $plan, Request $request) {

        $user = User::where('id', auth()->id())->first();
        $settings = Settings::first();

        $request->validate([
            'amount' => 'required|numeric',
            'balance' => 'required',
        ]);

        $balanceMethod = Wdmethod::where('symbol', $request->balance)->first();
        $balance = $user->balances()->where('wdmethod_id', $balanceMethod->id)->first();

        $amountInCoin = $this->amountInCoin($request->amount, $balanceMethod);

        if ($amountInCoin > $balance->value) {
            return back()->with('error', 'Insufficient Balance.')->withInput();
        }

        if ($plan->min_price && $request->amount < $plan->min_price) {
            return back()->with('error', 'Amount to be invested can not be lesser than the minimum amount.')->withInput();
        }

        if ($plan->max_price && $request->amount > $plan->max_price) {
            return back()->with('error', 'Amount to be invested can not be greater than the maximum amount.')->withInput();
        }

        $balance->decrement('value', $amountInCoin);

        $expiration = explode(" ", $plan->expiration);
        $digit = $expiration[0];
        $frame = $expiration[1];
        $toexpire =  "add" . $frame;
        $end_at = now()->$toexpire($digit)->toDateTimeString();

        Tp_Transaction::create([
            'user' => $user->id,
            'plan' => $plan->name,
            'amount' => $request->amount,
            'type' => "Plan purchase",
        ]);

        switch ($plan->increment_interval) {
            case 'Monthly':
                $nextDrop = now()->addDays(27);
                break;

            case 'Weekly':
                $nextDrop = now()->addDays(6);
                break;

            case 'Daily':
                $nextDrop = now()->addHours(23);
                break;

            case 'Hourly':
                $nextDrop = now()->addMinutes(54);
                break;

            case 'Every 30 Minutes':
                $nextDrop = now()->addMinutes(24);
                break;

            default:
                $nextDrop = now()->addMinutes(7);
                break;
        }

        $user_plan = User_plans::create([
            'user' => $user->id,
            'plan' => $plan->id,
            'amount' => $request->amount,
            'active' => 'yes',
            'inv_duration' => $plan->expiration,
            'expire_date' => $end_at,
            'activated_at' => now(),
            'last_growth' => $nextDrop,
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        $user->update([
            'plan' => $plan->id,
            'user_plan' => $user_plan->id,
            'entered_at' => now(),
        ]);

        $message = "This is to inform you that $user->name just purchased an investment plan: $plan->name";
        $subject = "$user->name just purchased an investment plan";

        $user->notify(new AccountNotification("You just purchased a new investment plan: {$plan->name}, amount: {$settings->currency}{$request->amount}.", 'New Investment Plan'));
        Mail::to($settings->contact_email)->send(new NewNotification($message, $subject, 'Admin'));

        return redirect(route('invest'))->with('success', "You Have Successfully Purchased $plan->name.");
    }

    public function investments() {
        $settings = Settings::where('id', 1)->first();
        return view("{$settings->theme}.user.invest.investments", [
            'title' => 'Active and Pending Investments',
            'user' => auth()->user(),
        ]);
    }

    public function history() {
        $settings = Settings::where('id', 1)->first();
        $user = User::find(auth()->id());
        $investments = User_plans::with(['dplan'])->where('user', $user->id)->get();

        return view("{$settings->theme}.user.invest.history", [
            'title' => 'Investment History',
            'user' => $user,
            'id' => 1,
            'investments' => $investments
        ]);
    }
}
