<?php

namespace App\Http\Controllers\User;

use App\Models\Settings;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Inbox;
use App\Models\User;

class InboxController extends Controller {
    public function index() {
        $settings = Settings::where('id', 1)->first();
        $user = User::find(auth()->id());

        return view("{$settings->theme}.user.inbox.index", [
            'title' => 'Conversation',
            'inboxes' => $user->inboxes,
            'user' => $user,
            'id' => 1,
            'shorten' => fn ($text) => $this->shorten($text),
        ]);
    }

    public function create(Request $request) {
        
        $request->validate([
            'subject' => 'required|string|max:255',
            'message' => 'required|string'
        ]);

        $inbox = Inbox::create([
            'user_id' => auth()->id(),
            'subject' => $request->subject,
            'ref' => $this->generateRandomRef(),
            'date' => now(),
        ]);

        $inbox->conversations()->create([
            'sender' => 'user',
            'content' => $request->message,
        ]);

        return redirect(route('inbox-details', $inbox->ref))->with('success', 'Conversation created successfully.');
    }

    public function details(Inbox $inbox) {
        if($inbox->user->id !== auth()->id()) {
            abort(403);
        }

        $settings = Settings::where('id', 1)->first();
        $user = User::find(auth()->id());

        return view("{$settings->theme}.user.inbox.conversation", [
            'title' => 'Conversation',
            'user' => $user,
            'conversations' => $inbox->conversations,
            'inbox' => $inbox,
        ]);
    }

    public function createConversation(Inbox $inbox, Request $request) {
        if($inbox->status == 'closed') {
            $inbox->update([
                'status' => 'open'
            ]);
        }

        $user = User::find(auth()->id());

        $request->validate([
            'message' => 'required|string'
        ]);

        $inbox->conversations()->create([
            'sender' => 'user',
            'content' => $request->message,
        ]);

        return back()->with('success', 'Response added. Support will be with you soon.');
    }

    public function close(Inbox $inbox) {
        $inbox->update([
            'status' => 'closed'
        ]);

        return redirect(route('inboxes'))->with('success', 'Conversation Ended.');
    }
}
