<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use App\Models\Settings;
use App\Models\Wdmethod;
use App\Traits\TemplateTrait;
use Illuminate\Http\Request;

class CoinController extends Controller
{
    use TemplateTrait;

    function deposit(Wdmethod $method) {
        $settings = Settings::where('id', 1)->first();
        return view("{$settings->theme}.user.deposit", [
            'title' => 'New Deposit',
            'user' => auth()->user(),
            'method' => $method,
            'methods' => Wdmethod::crypto(),
        ]);
    }

    function send() {
        $settings = Settings::where('id', 1)->first();
        return view("{$settings->theme}.user.send", [
            'title' => 'Withdraw',
            'user' => auth()->user(),
            'methods' => Wdmethod::crypto(),
        ]);
    }
}
