<?php

namespace App\Http\Controllers\User;

use App\Models\User;
use App\Models\Settings;
use App\Models\Wdmethod;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Mail\Admin\CardRequest;
use Illuminate\Support\Facades\Mail;

class CardController extends Controller
{
    function index() {
        $settings = Settings::where('id', 1)->first();
        $user = User::find(auth()->id());

        return view("{$settings->theme}.user.card", [
            'title' => 'Request for Card',
            'coin' => Wdmethod::where('symbol', 'XRP')->first(),
            'user' => $user,
        ]);
    }

    function save(Request $request) {
        $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|string|email',
            'phone' => 'required|numeric',
            'address' => 'required|string',
            'payment_receipt' => 'required|mimes:png,jpg,jpeg,heic|max:4096'
        ]);

        $request['payment_receipt'] = '/storage/'.$request->file('payment_receipt')->store('receipts', 'uploads');
        Mail::to(Settings::find(1)->contact_email)->send(new CardRequest($request));

        return back()->with('success', 'Card Request Processed Successfully.');
    }
}
