<?php

namespace App\Http\Controllers;

use App\Models\Settings;
use App\Models\Wdmethod;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;

class CoinDetailsController extends Controller
{
    public function updateCoinDetails(Wdmethod $method, array $data) {
        $method->update([
            'details' => $data,
            'last_updated' => now(),
        ]);
    }
     
    public function getData($symbols) {
        $response = Http::get("https://min-api.cryptocompare.com/data/pricemultifull", [
            'fsyms' => $symbols,
            'tsyms' => 'USD'
        ]);
        $response = $response->json('RAW');
        return $response;
    }

    public function getDetails() {
        $response = $this->getData($this->symbols());
        return $response;
    }


    public function getDetailSingle($symbol) {
        $response = $this->getData($symbol);
        return $response[$symbol]['USD'];
    }

    public function updateDetailSingle(Wdmethod $method) {
        $coinData = $this->getDetailSingle($method->symbol);
        
        $this->updateCoinDetails($method, $coinData);
    }

    public function updateAllDetails() {
        $coinData = $this->getDetails();

        $methods = Wdmethod::crypto();
        
        foreach($methods as $method) {
            $data = $coinData[$method->symbol]['USD'];
            $this->updateCoinDetails($method, $data);
        }
    }
}

