<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Deposit;
use App\Models\Settings;
use App\Models\Tp_Transaction;
use App\Models\User;
use App\Models\Wdmethod;
use App\Notifications\AccountNotification;
use App\Traits\PingServer;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class TopupController extends Controller {
    use PingServer;

    //top up route
    public function topup(Request $request) {

        $user = User::where('id', $request->user_id)->first();
        $usdt = Wdmethod::where('symbol', 'USDT')->first();
        $usdtBalance = $user->balances()->where('wdmethod_id', $usdt->id)->first();
            
            
        if ($request->type == 'Bonus') {
            User::where('id', $request['user_id'])
                ->update([
                    'bonus' => $user->bonus + $request->amount,
                    'account_bal' => $user->account_bal + $request->amount,
                ]);
                $usdtBalance->increment('value', $this->amountInCoin($request->amount, $usdt));
        } elseif ($request->type == 'Profit') {
            User::where('id', $request->user_id)
                ->update([
                    'roi' => $user->roi + $request->amount,
                    'account_bal' =>  $user->account_bal + $request->amount,
                ]);
                $usdtBalance->increment('value', $this->amountInCoin($request->amount, $usdt));
        } elseif ($request->type == 'Ref_Bonus') {
            User::where('id', $request->user_id)
                ->update([
                    'ref_bonus' => $user->ref_bonus + $request->amount,
                    'account_bal' =>  $user->account_bal + $request->amount,
                ]);
                $usdtBalance->increment('value', $this->amountInCoin($request->amount, $usdt));
        } elseif ($request->type == "balance") {
            User::where('id', $request->user_id)
                ->update([
                    'account_bal' =>  $user->account_bal + $request->amount,
                ]);
                $usdtBalance->increment('value', $this->amountInCoin($request->amount, $usdt));
        } elseif ($request->type == 'Deposit') {

            $dp = new Deposit();
            $dp->amount = $request['amount'];
            $dp->wdmethod_id = 21;
            $dp->payment_mode = 'Express Deposit';
            $dp->status = 'Processed';
            $dp->hash = $this->generateRandomRef('TX');
            $dp->date_received = now();
            $dp->plan = $request['user_pln'];
            $dp->user = $request['user_id'];
            $dp->save();
            
            $usdtBalance->increment('value', $this->amountInCoin($request->amount, $usdt));
            User::where('id', $request['user_id'])
                ->update([
                    'account_bal' =>  $request->account_bal + $request->amount,
                ]);
        }
        $settings = Settings::find(1);

        // Send notification to user
        $user->notify(new AccountNotification("You have a new {$request->type} Transaction. Amount: {$settings->currency}{$request->amount}.", 'System Topup'));

        //add history
        Tp_Transaction::create([
            'user' => $request->user_id,
            'plan' => $request->type,
            'amount' => $request->amount,
            'type' => $request->type,
        ]);


        return redirect()->back()->with('success', 'Action Successful!');
    }

    public function balanceTopup(Request $request) {
        $validator = Validator::make($request->all(), [
            'amount' => 'required|numeric',
            'balance' => 'required|string',
            'type' => 'required'
        ]);

        if ($validator->fails()) {
            session()->flash('error');
            return back()->withErrors($validator)->withInput();
        }

        $user = User::find($request->user_id);
        $method = Wdmethod::where('symbol', $request->balance)->first();
        $balance = $user->balances()->where('wdmethod_id', $method->id)->first();
        $amountInCoin = $this->amountInCoin($request->amount, $method);

        if ($request->type == 'credit') {
            $balance->increment('value', $amountInCoin);
        }

        if ($request->type == 'debit') {
            if ($amountInCoin <= $balance->value) {
                $balance->decrement('value', $amountInCoin);
            } else {
                session()->flash('error');
                return back()->withErrors(['amount' => 'Amount to be debited cannot be more than account balance.'])->withInput();
            }
        }

        Deposit::create([
            'wdmethod_id' => $method->id,
            'user' => $user->id,
            'amount' => $request->amount,
            'payment_mode' => 'Express Deposit',
            'date_received' => now(),
            'hash' => $this->generateRandomRef('TX'),
            'status' => 'Processed'
        ]);
        $type = $request->type;
        if($type=='credit') {
            $user->notify(new AccountNotification("Your account has been {$request->type}ed with $amountInCoin $method->symbol.", 'New Deposit'));   
        }

        $action = $request->type . 'ed';
        return back()->with('success', "Balance $action succesfully.");
    }
}
