<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Inbox;
use Illuminate\Http\Request;

class InboxController extends Controller
{
    public function index() {
        return view('admin.inboxes.index', [
            'title' => 'Inboxes',
            'inboxes' => Inbox::orderByDesc('created_at')->with('conversations')->get(),
        ]);
    }

    public function details(Inbox $inbox) {
        return view('admin.inboxes.details', [
            'title' => 'Inbox Details',
            'inbox' => $inbox,
        ]);
    }

    public function updateDetails(Inbox $inbox, Request $request) {
        $details = $request->validate([
            'subject' => 'required|max:255',
            'date' => 'required|date',
            'status' => 'required|max:255'
        ]);
        
        $inbox->update($details);
        return redirect(route('admin.inboxes'))->with('success', 'Inbox updated successfully.');
    }

    public function conversations(Inbox $inbox) {
        return view('admin.inboxes.conversations',[
            'title' => 'Inbox Conversations',
            'inbox' => $inbox,
        ]);
    }
}
